var data = require('./build/data.json')

Object.keys(data).forEach(function(key) {

  // Returns a string representation of html attributes
  var htmlAttributes = function(icon, options) {
    var attributes = []
    var attrObj = Object.assign({}, data[key].options, options)

    // If the user passed in options
    if (options) {

      // If any of the width or height is passed in
      if(options["width"] || options["height"]) {
        attrObj["width"] = options["width"] ? options["width"] : (parseInt(options["height"]) * data[key].options["width"] / data[key].options["height"])
        attrObj["height"] = options["height"] ? options["height"] : (parseInt(options["width"]) * data[key].options["height"] / data[key].options["width"])
      }

      // If the user passed in class
      if (options["class"]) {
        attrObj["class"] = "octicon octicon-" + key + " " + options["class"]
        attrObj["class"].trim()
      }

      // If the user passed in aria-label
      if (options["aria-label"]) {
        attrObj["aria-label"] = options["aria-label"]
        attrObj["role"] = "img"

        // Un-hide the icon
        delete attrObj["aria-hidden"]
      }
    }

    Object.keys(attrObj).forEach(function(option) {
      attributes.push(option + "=\"" + attrObj[option] + "\"")
    })

    return attributes.join(" ").trim()
  }

  // Set the symbol for easy access
  data[key].symbol = key

  // Set all the default options
  data[key].options = {
    "version": "1.1",
    "width": data[key].width,
    "height": data[key].height,
    "viewBox": "0 0 " + data[key].width + " " + data[key].height,
    "class": "octicon octicon-" + key,
    "aria-hidden": "true"
  }

  // Function to return an SVG object
  data[key].toSVG = function(options) {
    return "<svg " + htmlAttributes(data[key], options) + ">" + data[key].path + "</svg>"
  }

  // Function to return an SVG object with a use, assuming you use the svg sprite
  data[key].toSVGUse = function(options) {
    return "<svg " + htmlAttributes(data[key], options) + "><use xlink:href=\"#" + key + "\" /></svg>"
  }
})

// Import data into exports
module.exports = data
