<?php
/* Copyright (C) 2011	   Dimitri Mouillard	<dmouillard@teclib.com>
 * Copyright (C) 2013-2017 Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2012-2016 Regis Houssin		<regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       htdocs/holiday/list.php
 *		\ingroup    holiday
 *		\brief      List of holiday
 */

require('../main.inc.php');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/holiday/common.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';

$langs->load('users');
$langs->load('holidays');
$langs->load('hrm');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$limit = GETPOST('limit')?GETPOST('limit','int'):$conf->liste_limit;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;

if (! $sortfield) $sortfield="cp.rowid";
if (! $sortorder) $sortorder="DESC";
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;

$id = GETPOST('id','int');

$sall            = GETPOST('sall', 'alphanohtml');
$search_ref      = GETPOST('search_ref');
$month_create    = GETPOST('month_create');
$year_create     = GETPOST('year_create');
$month_start     = GETPOST('month_start');
$year_start      = GETPOST('year_start');
$month_end       = GETPOST('month_end');
$year_end        = GETPOST('year_end');
$search_employee = GETPOST('search_employee');
$search_valideur = GETPOST('search_valideur');
$search_statut   = GETPOST('select_statut');
$search_type     = GETPOST('search_type','int');

// List of fields to search into when doing a "search in all"
$fieldstosearchall = array(
    'cp.description'=>'Description',
    'uu.lastname'=>'EmployeeLastname',
    'uu.firstname'=>'EmployeeFirstname'
);



/*
 * Actions
 */

if (GETPOST('button_removefilter_x','alpha') || GETPOST('button_removefilter.x','alpha') || GETPOST('button_removefilter','alpha')) // All tests are required to be compatible with all browsers
{
	$search_ref="";
	$month_create="";
	$year_create="";
    $month_start="";
	$year_start="";
	$month_end="";
	$year_end="";
	$search_employee="";
	$search_valideur="";
	$search_statut="";
	$search_type='';
}



/*
 * View
 */

$holiday = new Holiday($db);
$holidaystatic=new Holiday($db);
$fuser = new User($db);

$childids = $user->getAllChildIds();
$childids[]=$user->id;

// Update sold
$result = $holiday->updateBalance();

$max_year = 5;
$min_year = 10;
$filter='';

llxHeader('', $langs->trans('CPTitreMenu'));

$order = $db->order($sortfield,$sortorder).$db->plimit($limit + 1, $offset);

// Ref
if(!empty($search_ref))
{
    $filter.= " AND cp.rowid = ".$db->escape($search_ref);
}

// Start date
if($year_start > 0) {
    if($month_start > 0) {
    	$filter .= " AND (cp.date_debut BETWEEN '".$db->idate(dol_get_first_day($year_start,$month_start,1))."' AND '".$db->idate(dol_get_last_day($year_start,$month_start,1))."')";
    	//$filter.= " AND date_format(cp.date_debut, '%Y-%m') = '$year_start-$month_start'";
    } else {
    	$filter .= " AND (cp.date_debut BETWEEN '".$db->idate(dol_get_first_day($year_start,1,1))."' AND '".$db->idate(dol_get_last_day($year_start,12,1))."')";
    	//$filter.= " AND date_format(cp.date_debut, '%Y') = '$year_start'";
    }
} else {
    if($month_start > 0) {
        $filter.= " AND date_format(cp.date_debut, '%m') = '".$db->escape($month_start)."'";
    }
}

// End date
if($year_end > 0) {
    if($month_end > 0) {
    	$filter .= " AND (cp.date_fin BETWEEN '".$db->idate(dol_get_first_day($year_end,$month_end,1))."' AND '".$db->idate(dol_get_last_day($year_end,$month_end,1))."')";
    	//$filter.= " AND date_format(cp.date_fin, '%Y-%m') = '$year_end-$month_end'";
    } else {
    	$filter .= " AND (cp.date_fin BETWEEN '".$db->idate(dol_get_first_day($year_end,1,1))."' AND '".$db->idate(dol_get_last_day($year_end,12,1))."')";
    	//$filter.= " AND date_format(cp.date_fin, '%Y') = '$year_end'";
    }
} else {
    if($month_end > 0) {
        $filter.= " AND date_format(cp.date_fin, '%m') = '".$db->escape($month_end)."'";
    }
}

// Create date
if($year_create > 0) {
    if($month_create > 0) {
    	$filter .= " AND (cp.date_create BETWEEN '".$db->idate(dol_get_first_day($year_create,$month_create,1))."' AND '".$db->idate(dol_get_last_day($year_create,$month_create,1))."')";
    	//$filter.= " AND date_format(cp.date_create, '%Y-%m') = '$year_create-$month_create'";
    } else {
    	$filter .= " AND (cp.date_create BETWEEN '".$db->idate(dol_get_first_day($year_create,1,1))."' AND '".$db->idate(dol_get_last_day($year_create,12,1))."')";
    	//$filter.= " AND date_format(cp.date_create, '%Y') = '$year_create'";
    }
} else {
    if($month_create > 0) {
        $filter.= " AND date_format(cp.date_create, '%m') = '".$db->escape($month_create)."'";
    }
}

// Employee
if(!empty($search_employee) && $search_employee != -1) {
    $filter.= " AND cp.fk_user = '".$db->escape($search_employee)."'\n";
}

// Validator
if(!empty($search_valideur) && $search_valideur != -1) {
    $filter.= " AND cp.fk_validator = '".$db->escape($search_valideur)."'\n";
}

// Type
if (!empty($search_type) && $search_type != -1) {
	$filter.= ' AND cp.fk_type IN ('.$db->escape($search_type).')';
}

// Status
if(!empty($search_statut) && $search_statut != -1) {
    $filter.= " AND cp.statut = '".$db->escape($search_statut)."'\n";
}
// Search all
if (!empty($sall))
{
	$filter.= natural_search(array_keys($fieldstosearchall), $sall);
}

if (empty($user->rights->holiday->read_all)) $filter.=' AND cp.fk_user IN ('.join(',',$childids).')';


// Récupération de l'ID de l'utilisateur
$user_id = $user->id;

if ($id > 0)
{
	// Charge utilisateur edite
	$fuser->fetch($id, '', '', 1);
	$fuser->getrights();
	$user_id = $fuser->id;
}

// Récupération des congés payés de l'utilisateur ou de tous les users
if (empty($user->rights->holiday->read_all) || $id > 0)
{
	$result = $holiday->fetchByUser($user_id,$order,$filter);	// Load array $holiday->holiday
}
else
{
    $result = $holiday->fetchAll($order,$filter);	// Load array $holiday->holiday
}
// Si erreur SQL
if ($result == '-1')
{
    print load_fiche_titre($langs->trans('CPTitreMenu'), '', 'title_hrm.png');

    dol_print_error($db, $langs->trans('Error').' '.$holiday->error);
    exit();
}


// Show table of vacations

$var=true;
$num = count($holiday->holiday);
$form = new Form($db);
$formother = new FormOther($db);

$param='';
if (! empty($contextpage) && $contextpage != $_SERVER["PHP_SELF"]) $param.='&contextpage='.$contextpage;
if ($limit > 0 && $limit != $conf->liste_limit) $param.='&limit='.$limit;
if ($optioncss != '') $param.='&optioncss='.$optioncss;

print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
if ($optioncss != '') print '<input type="hidden" name="optioncss" value="'.$optioncss.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="list">';
print '<input type="hidden" name="sortfield" value="'.$sortfield.'">';
print '<input type="hidden" name="sortorder" value="'.$sortorder.'">';
print '<input type="hidden" name="page" value="'.$page.'">';
if ($id > 0) print '<input type="hidden" name="id" value="'.$id.'">';

if ($id > 0)
{
	$title = $langs->trans("User");
	$linkback = '<a href="'.DOL_URL_ROOT.'/user/index.php">'.$langs->trans("BackToList").'</a>';
	$head = user_prepare_head($fuser);

	dol_fiche_head($head, 'paidholidays', $title, 0, 'user');

    dol_banner_tab($fuser,'id',$linkback,$user->rights->user->user->lire || $user->admin);

	if (empty($conf->global->HOLIDAY_HIDE_BALANCE))
	{
	    print '<div class="underbanner clearboth"></div>';

	    print '<br>';

	    showMyBalance($holiday, $user_id);
	}

	dol_fiche_end();
}
else
{
    //print $num;
    //print count($holiday->holiday);
	print_barre_liste($langs->trans("ListeCP"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, count($holiday->holiday), 'title_hrm.png', 0, '', '', $limit);

	if (empty($conf->global->HOLIDAY_HIDE_BALANCE))
	{
		dol_fiche_head('');

		showMyBalance($holiday, $user_id);

		dol_fiche_end();
	}
}



/**
 * Show balance of user
 *
 * @param 	Holiday	$holiday	Object $holiday
 * @param	int		$user_id	User id
 * @return	string				Html code with balance
 */
function showMyBalance($holiday, $user_id)
{
	global $conf, $langs;

	$alltypeleaves=$holiday->getTypes(1,-1);    // To have labels

	$out='';
	$typeleaves=$holiday->getTypes(1,1);
	foreach($typeleaves as $key => $val)
	{
		$nb_type = $holiday->getCPforUser($user_id, $val['rowid']);
		$nb_holiday += $nb_type;
		$out .= ' - '.$val['label'].': <strong>'.($nb_type?price2num($nb_type):0).'</strong><br>';
	}
	print $langs->trans('SoldeCPUser', round($nb_holiday,5)).'<br>';
	print $out;
}



if ($id > 0) print '<br>';

if ($sall)
{
    foreach($fieldstosearchall as $key => $val) $fieldstosearchall[$key]=$langs->trans($val);
    print $langs->trans("FilterOnInto", $sall) . join(', ',$fieldstosearchall);
}

print '<div class="div-table-responsive">';
print '<table class="tagtable liste'.($moreforfilter?" listwithfilterbefore":"").'">'."\n";

// Filters
print '<tr class="liste_titre_filter">';
print '<td class="liste_titre" align="left">';
print '<input class="flat" size="4" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
print '</td>';

// Create date
print '<td class="liste_titre" align="center">';
print '<input class="flat" type="text" size="1" maxlength="2" name="month_create" value="'.dol_escape_htmltag($month_create).'">';
$formother->select_year($year_create,'year_create',1, $min_year, 0);
print '</td>';

// User
if ($user->rights->holiday->write_all)
{
    print '<td class="liste_titre maxwidthonsmartphone" align="left">';
    print $form->select_dolusers($search_employee,"search_employee",1,"",0,'','',0,0,0,'',0,'','maxwidth200');
    print '</td>';
}
else
{
    //print '<td class="liste_titre">&nbsp;</td>';
    print '<td class="liste_titre maxwidthonsmartphone" align="left">';
    print $form->select_dolusers($user->id,"search_employee",1,"",1,'','',0,0,0,'',0,'','maxwidth200');
    print '</td>';
}

// Approve
if($user->rights->holiday->write_all)
{
    print '<td class="liste_titre maxwidthonsmartphone" align="left">';

    $validator = new UserGroup($db);
    $excludefilter=$user->admin?'':'u.rowid <> '.$user->id;
    $valideurobjects = $validator->listUsersForGroup($excludefilter);
    $valideurarray = array();
    foreach($valideurobjects as $val) $valideurarray[$val->id]=$val->id;
    print $form->select_dolusers($search_valideur,"search_valideur",1,"",0,$valideurarray,'', 0, 0, 0, '', 0, '', 'maxwidth200');
    print '</td>';
}
else
{
    print '<td class="liste_titre">&nbsp;</td>';
}

// Type
print '<td class="liste_titre">';
$typeleaves=$holidaystatic->getTypes(1,-1);
$arraytypeleaves=array();
foreach($typeleaves as $key => $val)
{
    $labeltoshow = $val['label'];
    //$labeltoshow .= ($val['delay'] > 0 ? ' ('.$langs->trans("NoticePeriod").': '.$val['delay'].' '.$langs->trans("days").')':'');
    $arraytypeleaves[$val['rowid']]=$labeltoshow;
}
print $form->selectarray('search_type', $arraytypeleaves, (GETPOST('search_type')?GETPOST('search_type'):''), 1);
print '</td>';

// Duration
print '<td class="liste_titre">&nbsp;</td>';

// Start date
print '<td class="liste_titre" align="center">';
print '<input class="flat" type="text" size="1" maxlength="2" name="month_start" value="'.dol_escape_htmltag($month_start).'">';
$formother->select_year($year_start,'year_start',1, $min_year, $max_year);
print '</td>';

// End date
print '<td class="liste_titre" align="center">';
print '<input class="flat" type="text" size="1" maxlength="2" name="month_end" value="'.dol_escape_htmltag($month_end).'">';
$formother->select_year($year_end,'year_end',1, $min_year, $max_year);
print '</td>';

// Status
print '<td class="liste_titre maxwidthonsmartphone maxwidth200" align="right">';
$holiday->selectStatutCP($search_statut);
print '</td>';

// Actions
print '<td class="liste_titre" align="right">';
$searchpicto=$form->showFilterAndCheckAddButtons(0);
print $searchpicto;
print '</td>';

print "</tr>\n";

print '<tr class="liste_titre">';
print_liste_field_titre("Ref",$_SERVER["PHP_SELF"],"cp.rowid","",$param,'',$sortfield,$sortorder);
print_liste_field_titre("DateCreateCP",$_SERVER["PHP_SELF"],"cp.date_create","",$param,'align="center"',$sortfield,$sortorder);
print_liste_field_titre("Employee",$_SERVER["PHP_SELF"],"cp.fk_user","",$param,'',$sortfield,$sortorder);
print_liste_field_titre("ValidatorCP",$_SERVER["PHP_SELF"],"cp.fk_validator","",$param,'',$sortfield,$sortorder);
print_liste_field_titre("Type",$_SERVER["PHP_SELF"],'','',$param,'',$sortfield,$sortorder);
print_liste_field_titre("Duration",$_SERVER["PHP_SELF"],'','',$pram,'align="right"',$sortfield,$sortorder);
print_liste_field_titre("DateDebCP",$_SERVER["PHP_SELF"],"cp.date_debut","",$param,'align="center"',$sortfield,$sortorder);
print_liste_field_titre("DateFinCP",$_SERVER["PHP_SELF"],"cp.date_fin","",$param,'align="center"',$sortfield,$sortorder);
print_liste_field_titre("Status",$_SERVER["PHP_SELF"],"cp.statut","",$param,'align="right"',$sortfield,$sortorder);
print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$param,'',$sortfield,$sortorder,'maxwidthsearch ');
print "</tr>\n";

// Lines
if (! empty($holiday->holiday))
{
	$userstatic = new User($db);
	$approbatorstatic = new User($db);

	foreach($holiday->holiday as $infos_CP)
	{
		// User
		$userstatic->id=$infos_CP['fk_user'];
		$userstatic->lastname=$infos_CP['user_lastname'];
		$userstatic->firstname=$infos_CP['user_firstname'];
		$userstatic->login=$infos_CP['user_login'];
		$userstatic->statut=$infos_CP['user_statut'];
		$userstatic->photo=$infos_CP['user_photo'];

		// Validator
		$approbatorstatic->id=$infos_CP['fk_validator'];
		$approbatorstatic->lastname=$infos_CP['validator_lastname'];
		$approbatorstatic->firstname=$infos_CP['validator_firstname'];
		$approbatorstatic->login=$infos_CP['validator_login'];
		$approbatorstatic->statut=$infos_CP['validator_statut'];
		$approbatorstatic->photo=$infos_CP['validator_photo'];

		$date = $infos_CP['date_create'];

		print '<tr class="oddeven">';
		print '<td>';
		$holidaystatic->id=$infos_CP['rowid'];
		$holidaystatic->ref=$infos_CP['rowid'];
		print $holidaystatic->getNomUrl(1);
		print '</td>';
		print '<td style="text-align: center;">'.dol_print_date($date,'day').'</td>';
		print '<td>'.$userstatic->getNomUrl(-1, 'leave').'</td>';
		print '<td>'.$approbatorstatic->getNomUrl(-1).'</td>';
		print '<td>';
		$label=$alltypeleaves[$infos_CP['fk_type']]['label'];
		print $label?$label:$infos_CP['fk_type'];
		print '</td>';
		print '<td align="right">';
		$nbopenedday=num_open_day($infos_CP['date_debut_gmt'], $infos_CP['date_fin_gmt'], 0, 1, $infos_CP['halfday']);
		print $nbopenedday.' '.$langs->trans('DurationDays');
		print '</td>';
		print '<td align="center">'.dol_print_date($infos_CP['date_debut'],'day').'</td>';
		print '<td align="center">'.dol_print_date($infos_CP['date_fin'],'day').'</td>';
		print '<td align="right">'.$holidaystatic->LibStatut($infos_CP['statut'],5).'</td>';
		print '<td></td>';
		print '</tr>'."\n";

	}
}

// Si il n'y a pas d'enregistrement suite à une recherche
if ($result == '2')
{
    print '<tr>';
    print '<td colspan="10" class="opacitymedium">'.$langs->trans('NoRecordFound').'</td>';
    print '</tr>';
}

print '</table>';
print '</div>';

print '</form>';

/*if ($user_id == $user->id)
{
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=request" class="butAction">'.$langs->trans('AddCP').'</a>';
	print '</div>';
}*/

llxFooter();

$db->close();
