<?php

/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 * Copyright (C) 2016      Marcos García        <marcosgdf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   produit     Module product variants
 *  \brief      Module to manage product combinations based on product attributes
 *  \file       htdocs/core/modules/modAttributes.class.php
 *  \ingroup    produit
 *  \brief      File to describe module to manage catalog of predefined products
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module Product variants
 */
class modVariants extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	public function __construct($db)
	{
		global $langs,$conf;

		$this->db = $db;

		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 610;
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'variants';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "products";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = 'Allows creating products variant based on new attributes';
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = 'experimental';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='product';

		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		$this->module_parts = array();

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/mymodule/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into mymodule/admin directory, to use to setup module.
		$this->config_page_url = array(
			'admin.php@variants'
		);

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array(
			'modProduct'
		);		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("products");

		// Constants
		$this->const = array();

		// Array to add new pages in new tabs
		$this->tabs = array(
//			'product:+combinations:Combinaciones:products:1:/variants/combinations.php?id=__ID__'
		);

		// Dictionaries
		if (! isset($conf->mymodule->enabled))
		{
			$conf->mymodule=new stdClass();
			$conf->mymodule->enabled=0;
		}
		$this->dictionaries=array();

		// Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
		$this->boxes = array();			// List of boxes

		// Permissions
		$this->rights = array();		// Permission array used by this module

		// Main menu entries
		$this->menu = array(
			array(
				'fk_menu' => 'fk_mainmenu=products,fk_leftmenu=product',
				'type' => 'left',
				'titre' => 'VariantAttributes',
				'mainmenu' => 'products',
				'leftmenu' => 'product',
				'url' => '/variants/list.php',
				'langs' => 'products',
				'position' => 100,
				'enabled' => '$conf->product->enabled',
				'perms' => 1,
				'target' => '',
				'user' => 0
			)
		);			// List of menus to add
	}
}

