--
-- Menu base entries
-- This file is loaded when a menu handler base is activated (auguria, etc..)
--

delete from llx_menu where menu_handler=__HANDLER__ and entity=__ENTITY__;

-- 
-- table llx_menu
-- 
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '1', 1__+MAX_llx_menu__, __HANDLER__, 'top', 'home',        '', 0, '/index.php?mainmenu=home&amp;leftmenu=', 'Home', -1, '', '', '', 2, 10, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('societe|fournisseur', '( ! empty($conf->societe->enabled) && (empty($conf->global->SOCIETE_DISABLE_PROSPECTS) || empty($conf->global->SOCIETE_DISABLE_CUSTOMERS))) || ! empty($conf->fournisseur->enabled)',  2__+MAX_llx_menu__, __HANDLER__, 'top', 'companies',   '', 0, '/societe/index.php?mainmenu=companies&amp;leftmenu=', 'ThirdParties', -1, 'companies', '$user->rights->societe->lire || $user->rights->societe->contact->lire', '', 2, 20, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('product|service', '$conf->product->enabled || $conf->service->enabled', 3__+MAX_llx_menu__, __HANDLER__, 'top', 'products',    '', 0, '/product/index.php?mainmenu=products&amp;leftmenu=', 'Products/Services', -1, 'products', '$user->rights->produit->lire||$user->rights->service->lire', '', 0, 30, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('propal|commande|fournisseur|contrat|ficheinter', '$conf->propal->enabled || $conf->commande->enabled || $conf->supplier_order->enabled || $conf->contrat->enabled || $conf->ficheinter->enabled', 5__+MAX_llx_menu__, __HANDLER__, 'top', 'commercial',  '', 0, '/comm/index.php?mainmenu=commercial&amp;leftmenu=', 'Commercial', -1, 'commercial', '$user->rights->societe->lire || $user->rights->societe->contact->lire', '', 2, 40, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('comptabilite|accounting|facture|don|tax|salaries|loan', '$conf->comptabilite->enabled || $conf->accounting->enabled || $conf->facture->enabled || $conf->don->enabled  || $conf->tax->enabled || $conf->salaries->enabled || $conf->supplier_invoice->enabled || $conf->loan->enabled', 6__+MAX_llx_menu__, __HANDLER__, 'top', 'accountancy', '', 0, '/compta/index.php?mainmenu=accountancy&amp;leftmenu=', 'MenuFinancial', -1, 'compta', '$user->rights->compta->resultat->lire || $user->rights->accounting->plancompte->lire || $user->rights->facture->lire|| $user->rights->don->lire || $user->rights->tax->charges->lire || $user->rights->salaries->read || $user->rights->loan->read', '', 2, 50, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('banque|prelevement', '$conf->banque->enabled || $conf->prelevement->enabled', 14__+MAX_llx_menu__, __HANDLER__, 'top', 'bank', '', 0, '/compta/bank/index.php?mainmenu=bank&amp;leftmenu=bank', 'MenuBankCash', -1, 'banks', '$user->rights->banque->lire || $user->rights->prelevement->bons->lire', '', 0, 60, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('projet', '$conf->projet->enabled', 7__+MAX_llx_menu__, __HANDLER__, 'top', 'project',     '', 0, '/projet/index.php?mainmenu=project&amp;leftmenu=', 'Projects', -1, 'projects', '$user->rights->projet->lire', '', 2, 70, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('mailing|export|import|opensurvey|resource', '$conf->mailing->enabled || $conf->export->enabled || $conf->import->enabled || $conf->opensurvey->enabled || $conf->resource->enabled', 8__+MAX_llx_menu__, __HANDLER__, 'top', 'tools',       '', 0, '/core/tools.php?mainmenu=tools&amp;leftmenu=', 'Tools', -1, 'other', '$user->rights->mailing->lire || $user->rights->export->lire || $user->rights->import->run || $user->rights->opensurvey->read || $user->rights->resource->read', '', 2, 90, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('adherent', '$conf->adherent->enabled', 13__+MAX_llx_menu__, __HANDLER__, 'top', 'members',     '', 0, '/adherents/index.php?mainmenu=members&amp;leftmenu=', 'Members', -1, 'members', '$user->rights->adherent->lire', '', 2, 110, __ENTITY__);
insert into llx_menu (module, enabled, rowid, menu_handler, type, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('hrm|holiday|deplacement|expensereport', '$conf->hrm->enabled || $conf->holiday->enabled || $conf->deplacement->enabled || $conf->expensereport->enabled', 15__+MAX_llx_menu__, __HANDLER__, 'top', 'hrm', '', 0, '/hrm/index.php?mainmenu=hrm&amp;leftmenu=', 'HRM', -1, 'holiday', '$user->rights->hrm->employee->read || $user->rights->holiday->write || $user->rights->deplacement->lire || $user->rights->expensereport->lire', '', 0, 80, __ENTITY__);

-- Home - Dashboard
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '1', __HANDLER__, 'left', 90__+MAX_llx_menu__, 'home', '', 1__+MAX_llx_menu__, '/index.php', 'MyDashboard', 0, '', '', '', 2, 0, __ENTITY__);

-- Home - Setup
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$user->admin', __HANDLER__, 'left', 100__+MAX_llx_menu__, 'home', 'setup', 1__+MAX_llx_menu__, '/admin/index.php?leftmenu=setup', 'Setup', 0, 'admin', '', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 101__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/company.php?leftmenu=setup', 'MenuCompanySetup', 1, 'admin', '', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 102__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/ihm.php?leftmenu=setup', 'GUISetup', 1, 'admin', '', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 114__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/translation.php?leftmenu=setup', 'Translation', 1, 'admin', '', '', 2, 4, __ENTITY__);

insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 103__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/modules.php?leftmenu=setup', 'Modules', 1, 'admin', '', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 104__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/boxes.php?leftmenu=setup', 'Boxes', 1, 'admin', '', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 105__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/menus.php?leftmenu=setup', 'Menus', 1, 'admin', '', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 106__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/delais.php?leftmenu=setup', 'Alerts', 1, 'admin', '', '', 2, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 108__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/security_other.php?leftmenu=setup', 'Security', 1, 'admin', '', '', 2, 8, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 110__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/limits.php?leftmenu=setup', 'MenuLimits', 1, 'admin', '', '', 2, 9, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 107__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/pdf.php?leftmenu=setup', 'PDF', 1, 'admin', '', '', 2, 10, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 109__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/mails.php?leftmenu=setup', 'Emails', 1, 'admin', '', '', 2, 11, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 113__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/sms.php?leftmenu=setup', 'SMS', 1, 'admin', '', '', 2, 12, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 111__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/dict.php?leftmenu=setup', 'Dictionary', 1, 'admin', '', '', 2, 13, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="setup"', __HANDLER__, 'left', 112__+MAX_llx_menu__, 'home', '', 100__+MAX_llx_menu__, '/admin/const.php?leftmenu=setup', 'OtherSetup', 1, 'admin', '', '', 2, 14, __ENTITY__);
-- Home - Admin tools
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$user->admin', __HANDLER__, 'left', 300__+MAX_llx_menu__, 'home', 'admintools', 1__+MAX_llx_menu__, '/admin/tools/index.php?leftmenu=admintools', 'AdminTools', 0, 'admin', '', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 201__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/dolibarr.php?leftmenu=admintools', 'InfoDolibarr', 1, 'admin', '', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 202__+MAX_llx_menu__, 'home', '', 201__+MAX_llx_menu__, '/admin/system/modules.php?leftmenu=admintools', 'Modules', 2, 'admin', '', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 203__+MAX_llx_menu__, 'home', '', 201__+MAX_llx_menu__, '/admin/triggers.php?leftmenu=admintools', 'Triggers', 2, 'admin', '', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 204__+MAX_llx_menu__, 'home', '', 201__+MAX_llx_menu__, '/admin/system/filecheck.php?leftmenu=admintools', 'FileCheck', 2, 'admin', '', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 205__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/browser.php?leftmenu=admintools', 'InfoBrowser', 1, 'admin', '', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 206__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/os.php?leftmenu=admintools', 'InfoOS', 1, 'admin', '', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 207__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/web.php?leftmenu=admintools', 'InfoWebServer', 1, 'admin', '', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 208__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/phpinfo.php?leftmenu=admintools', 'InfoPHP', 1, 'admin', '', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 210__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/database.php?leftmenu=admintools', 'InfoDatabase', 1, 'admin', '', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 301__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/dolibarr_export.php?leftmenu=admintools', 'Backup', 1, 'admin', '', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 302__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/dolibarr_import.php?leftmenu=admintools', 'Restore', 1, 'admin', '', '', 2, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 305__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/update.php?leftmenu=admintools', 'MenuUpgrade', 1, 'admin', '', '', 2, 8, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools" && function_exists("eaccelerator_info")', __HANDLER__, 'left', 306__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/eaccelerator.php?leftmenu=admintools', 'EAccelerator', 1, 'admin', '', '', 2, 9, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 307__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/listevents.php?leftmenu=admintools', 'Audit', 1, 'admin', '', '', 2, 10, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 308__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/listsessions.php?leftmenu=admintools', 'Sessions', 1, 'admin', '', '', 2, 11, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 309__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/tools/purge.php?leftmenu=admintools', 'Purge', 1, 'admin', '', '', 2, 12, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 311__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/admin/system/about.php?leftmenu=admintools', 'ExternalResources', 1, 'admin', '', '', 2, 14, __ENTITY__);

insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="admintools"', __HANDLER__, 'left', 320__+MAX_llx_menu__, 'home', '', 300__+MAX_llx_menu__, '/product/admin/product_tools.php?mainmenu=home&amp;leftmenu=admintools', 'ProductVatMassChange', 1, 'products', '', '', 2, 15, __ENTITY__);
-- Home - Menu users and groups
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '1', __HANDLER__, 'left', 400__+MAX_llx_menu__, 'home', 'users', 1__+MAX_llx_menu__, '/user/home.php?leftmenu=users', 'MenuUsersAndGroups', 0, 'users', '', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="users"', __HANDLER__, 'left', 401__+MAX_llx_menu__, 'home', '', 400__+MAX_llx_menu__, '/user/index.php?leftmenu=users', 'Users', 1, 'users', '$user->rights->user->user->lire || $user->admin', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="users"', __HANDLER__, 'left', 402__+MAX_llx_menu__, 'home', '', 401__+MAX_llx_menu__, '/user/card.php?leftmenu=users&amp;action=create', 'NewUser', 2, 'users', '($user->rights->user->user->creer || $user->admin) && !(! empty($conf->multicompany->enabled) && $conf->entity > 1 && $conf->global->MULTICOMPANY_TRANSVERSE_MODE)', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="users"', __HANDLER__, 'left', 403__+MAX_llx_menu__, 'home', '', 400__+MAX_llx_menu__, '/user/group/index.php?leftmenu=users', 'Groups', 1, 'users', '(($conf->global->MAIN_USE_ADVANCED_PERMS?$user->rights->user->group_advance->read:$user->rights->user->user->lire) || $user->admin) && !(! empty($conf->multicompany->enabled) && $conf->entity > 1 && $conf->global->MULTICOMPANY_TRANSVERSE_MODE)', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$leftmenu=="users"', __HANDLER__, 'left', 404__+MAX_llx_menu__, 'home', '', 403__+MAX_llx_menu__, '/user/group/card.php?leftmenu=users&amp;action=create', 'NewGroup', 2, 'users', '(($conf->global->MAIN_USE_ADVANCED_PERMS?$user->rights->user->group_advance->write:$user->rights->user->user->creer) || $user->admin) && !(! empty($conf->multicompany->enabled) && $conf->entity > 1 && $conf->global->MULTICOMPANY_TRANSVERSE_MODE)', '', 2, 0, __ENTITY__);
-- Third parties
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 500__+MAX_llx_menu__, 'companies', 'thirdparties', 2__+MAX_llx_menu__, '/societe/index.php?leftmenu=thirdparties', 'ThirdParty', 0, 'companies', '$user->rights->societe->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 501__+MAX_llx_menu__, 'companies', '', 500__+MAX_llx_menu__, '/societe/card.php?action=create', 'MenuNewThirdParty', 1, 'companies', '$user->rights->societe->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 502__+MAX_llx_menu__, 'companies', '', 500__+MAX_llx_menu__, '/societe/list.php?action=create', 'List', 1, 'companies', '$user->rights->societe->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->fournisseur->enabled', __HANDLER__, 'left', 503__+MAX_llx_menu__, 'companies', '', 500__+MAX_llx_menu__, '/societe/list.php?type=f&leftmenu=suppliers', 'ListSuppliersShort', 1, 'suppliers', '$user->rights->societe->lire && $user->rights->fournisseur->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->fournisseur->enabled', __HANDLER__, 'left', 504__+MAX_llx_menu__, 'companies', '', 503__+MAX_llx_menu__, '/societe/card.php?leftmenu=supplier&amp;action=create&amp;type=f', 'NewSupplier', 2, 'suppliers', '$user->rights->societe->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 506__+MAX_llx_menu__, 'companies', '', 500__+MAX_llx_menu__, '/societe/list.php?type=p&leftmenu=prospects', 'ListProspectsShort', 1, 'companies', '$user->rights->societe->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 507__+MAX_llx_menu__, 'companies', '', 506__+MAX_llx_menu__, '/societe/card.php?leftmenu=prospects&amp;action=create&amp;type=p', 'MenuNewProspect', 2, 'companies', '$user->rights->societe->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 509__+MAX_llx_menu__, 'companies', '', 500__+MAX_llx_menu__, '/societe/list.php?type=c&leftmenu=customers', 'ListCustomersShort', 1, 'companies', '$user->rights->societe->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 510__+MAX_llx_menu__, 'companies', '', 509__+MAX_llx_menu__, '/societe/card.php?leftmenu=customers&amp;action=create&amp;type=c', 'MenuNewCustomer', 2, 'companies', '$user->rights->societe->creer', '', 2, 0, __ENTITY__);
-- Third parties - Contacts
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 600__+MAX_llx_menu__, 'companies', 'contacts', 2__+MAX_llx_menu__, '/contact/list.php?leftmenu=contacts', 'ContactsAddresses', 0, 'companies', '$user->rights->societe->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 601__+MAX_llx_menu__, 'companies', '', 600__+MAX_llx_menu__, '/contact/card.php?leftmenu=contacts&amp;action=create', 'NewContactAddress', 1, 'companies', '$user->rights->societe->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 602__+MAX_llx_menu__, 'companies', '', 600__+MAX_llx_menu__, '/contact/list.php?leftmenu=contacts', 'List', 1, 'companies', '$user->rights->societe->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 604__+MAX_llx_menu__, 'companies', '', 602__+MAX_llx_menu__, '/contact/list.php?leftmenu=contacts&amp;type=p', 'ThirdPartyProspects', 2, 'companies', '$user->rights->societe->contact->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 605__+MAX_llx_menu__, 'companies', '', 602__+MAX_llx_menu__, '/contact/list.php?leftmenu=contacts&amp;type=c', 'ThirdPartyCustomers', 2, 'companies', '$user->rights->societe->contact->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->fournisseur->enabled', __HANDLER__, 'left', 606__+MAX_llx_menu__, 'companies', '', 602__+MAX_llx_menu__, '/contact/list.php?leftmenu=contacts&amp;type=f', 'ThirdPartySuppliers', 2, 'companies', '$user->rights->societe->contact->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled', __HANDLER__, 'left', 607__+MAX_llx_menu__, 'companies', '', 602__+MAX_llx_menu__, '/contact/list.php?leftmenu=contacts&amp;type=o', 'Others', 2, 'companies', '$user->rights->societe->contact->lire', '', 2, 4, __ENTITY__);
-- Third parties - Category customer
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 650__+MAX_llx_menu__, 'companies', 'cat', 2__+MAX_llx_menu__, '/categories/index.php?leftmenu=cat&amp;type=1', 'SuppliersCategoriesShort', 0, 'categories', '$user->rights->categorie->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 651__+MAX_llx_menu__, 'companies', '', 650__+MAX_llx_menu__, '/categories/card.php?action=create&amp;type=1', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- Third parties - Category supplier
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->fournisseur->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 660__+MAX_llx_menu__, 'companies', 'cat', 2__+MAX_llx_menu__, '/categories/index.php?leftmenu=cat&amp;type=2', 'CustomersProspectsCategoriesShort', 0, 'categories', '$user->rights->categorie->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->fournisseur->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 661__+MAX_llx_menu__, 'companies', '', 660__+MAX_llx_menu__, '/categories/card.php?action=create&amp;type=2', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- Third parties - Category contact
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 670__+MAX_llx_menu__, 'companies', 'cat', 2__+MAX_llx_menu__, '/categories/index.php?leftmenu=cat&amp;type=4', 'ContactCategoriesShort', 0, 'categories', '$user->rights->categorie->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->societe->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 671__+MAX_llx_menu__, 'companies', '', 670__+MAX_llx_menu__, '/categories/card.php?action=create&amp;type=4', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- Product - Product
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->product->enabled', __HANDLER__, 'left', 2800__+MAX_llx_menu__, 'products', 'product', 3__+MAX_llx_menu__, '/product/index.php?leftmenu=product&amp;type=0', 'Products', 0, 'products', '$user->rights->produit->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->product->enabled', __HANDLER__, 'left', 2801__+MAX_llx_menu__, 'products', '', 2800__+MAX_llx_menu__, '/product/card.php?leftmenu=product&amp;action=create&amp;type=0', 'NewProduct', 1, 'products', '$user->rights->produit->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->product->enabled', __HANDLER__, 'left', 2802__+MAX_llx_menu__, 'products', '', 2800__+MAX_llx_menu__, '/product/list.php?leftmenu=product&amp;type=0', 'List', 1, 'products', '$user->rights->produit->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->product->enabled', __HANDLER__, 'left', 2803__+MAX_llx_menu__, 'products', '', 2800__+MAX_llx_menu__, '/product/reassort.php?type=0', 'Stocks', 1, 'products', '$user->rights->produit->lire && $user->rights->stock->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->productbatch->enabled', __HANDLER__, 'left', 2805__+MAX_llx_menu__, 'products', '', 2800__+MAX_llx_menu__, '/product/reassortlot.php?type=0', 'StocksByLotSerial', 1, 'products', '$user->rights->produit->lire && $user->rights->stock->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->productbatch->enabled', __HANDLER__, 'left', 2806__+MAX_llx_menu__, 'products', '', 2800__+MAX_llx_menu__, '/product/stock/productlot_list.php', 'LotSerial', 1, 'products', '$user->rights->produit->lire && $user->rights->stock->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled', __HANDLER__, 'left', 2804__+MAX_llx_menu__, 'products', '', 2800__+MAX_llx_menu__, '/product/stats/card.php?id=all&amp;leftmenu=stats&amp;type=0', 'Statistics', 1, 'main', '$user->rights->produit->lire', '', 2, 7, __ENTITY__);
-- Product - Services
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->service->enabled', __HANDLER__, 'left', 2900__+MAX_llx_menu__, 'products', 'service', 3__+MAX_llx_menu__, '/product/index.php?leftmenu=service&amp;type=1', 'Services', 0, 'products', '$user->rights->service->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->service->enabled', __HANDLER__, 'left', 2901__+MAX_llx_menu__, 'products', '', 2900__+MAX_llx_menu__, '/product/card.php?leftmenu=service&amp;action=create&amp;type=1', 'NewService', 1, 'products', '$user->rights->service->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->service->enabled', __HANDLER__, 'left', 2902__+MAX_llx_menu__, 'products', '', 2900__+MAX_llx_menu__, '/product/list.php?leftmenu=service&amp;type=1', 'List', 1, 'products', '$user->rights->service->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled', __HANDLER__, 'left', 2903__+MAX_llx_menu__, 'products', '', 2900__+MAX_llx_menu__, '/product/stats/card.php?id=all&amp;leftmenu=stats&amp;type=1', 'Statistics', 1, 'main', '$user->rights->service->lire', '', 2, 5, __ENTITY__);
-- Product - Stocks
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->stock->enabled', __HANDLER__, 'left', 3100__+MAX_llx_menu__, 'products', 'stock', 3__+MAX_llx_menu__, '/product/stock/index.php?leftmenu=stock', 'Stock', 0, 'stocks', '$user->rights->stock->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->stock->enabled', __HANDLER__, 'left', 3101__+MAX_llx_menu__, 'products', '', 3100__+MAX_llx_menu__, '/product/stock/card.php?action=create', 'MenuNewWarehouse', 1, 'stocks', '$user->rights->stock->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->stock->enabled', __HANDLER__, 'left', 3102__+MAX_llx_menu__, 'products', '', 3100__+MAX_llx_menu__, '/product/stock/list.php', 'List', 1, 'stocks', '$user->rights->stock->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->stock->enabled', __HANDLER__, 'left', 3104__+MAX_llx_menu__, 'products', '', 3100__+MAX_llx_menu__, '/product/stock/mouvement.php', 'Movements', 1, 'stocks', '$user->rights->stock->mouvement->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->stock->enabled && $conf->supplier_order->enabled', __HANDLER__, 'left', 3105__+MAX_llx_menu__, 'products', '', 3100__+MAX_llx_menu__, '/product/stock/replenish.php', 'Replenishments', 1, 'stocks', '$user->rights->stock->mouvement->creer && $user->rights->fournisseur->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->stock->enabled', __HANDLER__, 'left', 3106__+MAX_llx_menu__, 'products', '', 3100__+MAX_llx_menu__, '/product/stock/massstockmove.php', 'MassStockTransferShort', 1, 'stocks', '$user->rights->stock->mouvement->creer', '', 2, 5, __ENTITY__);

-- Product - Categories
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->categorie->enabled', __HANDLER__, 'left', 3200__+MAX_llx_menu__, 'products', 'cat', 3__+MAX_llx_menu__, '/categories/index.php?leftmenu=cat&amp;type=0', 'Categories', 0, 'categories', '$user->rights->categorie->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->categorie->enabled', __HANDLER__, 'left', 3201__+MAX_llx_menu__, 'products', '', 3200__+MAX_llx_menu__, '/categories/card.php?action=create&amp;type=0', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- Product - Shipment
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expedition->enabled', __HANDLER__, 'left', 1300__+MAX_llx_menu__, 'commercial', 'sendings', 3__+MAX_llx_menu__, '/expedition/index.php?leftmenu=sendings', 'Shipments', 0, 'sendings', '$user->rights->expedition->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expedition->enabled && $leftmenu=="sendings"', __HANDLER__, 'left', 1301__+MAX_llx_menu__, 'commercial', '', 1300__+MAX_llx_menu__, '/expedition/card.php?action=create2&leftmenu=sendings', 'NewSending', 1, 'sendings', '$user->rights->expedition->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expedition->enabled && $leftmenu=="sendings"', __HANDLER__, 'left', 1302__+MAX_llx_menu__, 'commercial', '', 1300__+MAX_llx_menu__, '/expedition/list.php?leftmenu=sendings', 'List', 1, 'sendings', '$user->rights->expedition->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expedition->enabled && $leftmenu=="sendings"', __HANDLER__, 'left', 1303__+MAX_llx_menu__, 'commercial', '', 1300__+MAX_llx_menu__, '/expedition/stats/index.php?leftmenu=sendings', 'Statistics', 1, 'sendings', '$user->rights->expedition->lire', '', 2, 2, __ENTITY__);

-- Commercial - Proposals
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled', __HANDLER__, 'left', 1100__+MAX_llx_menu__, 'commercial', 'propals', 5__+MAX_llx_menu__, '/comm/propal/index.php?leftmenu=propals', 'Prop', 0, 'propal', '$user->rights->propale->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled', __HANDLER__, 'left', 1101__+MAX_llx_menu__, 'commercial', '', 1100__+MAX_llx_menu__, '/comm/propal/card.php?action=create&amp;leftmenu=propals', 'NewPropal', 1, 'propal', '$user->rights->propale->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled', __HANDLER__, 'left', 1102__+MAX_llx_menu__, 'commercial', '', 1100__+MAX_llx_menu__, '/comm/propal/list.php?leftmenu=propals', 'List', 1, 'propal', '$user->rights->propale->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled && $leftmenu=="propals"', __HANDLER__, 'left', 1103__+MAX_llx_menu__, 'commercial', '', 1102__+MAX_llx_menu__, '/comm/propal/list.php?leftmenu=propals&amp;viewstatut=0', 'PropalsDraft', 1, 'propal', '$user->rights->propale->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled && $leftmenu=="propals"', __HANDLER__, 'left', 1104__+MAX_llx_menu__, 'commercial', '', 1102__+MAX_llx_menu__, '/comm/propal/list.php?leftmenu=propals&amp;viewstatut=1', 'PropalsOpened', 1, 'propal', '$user->rights->propale->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled && $leftmenu=="propals"', __HANDLER__, 'left', 1105__+MAX_llx_menu__, 'commercial', '', 1102__+MAX_llx_menu__, '/comm/propal/list.php?leftmenu=propals&amp;viewstatut=2', 'PropalStatusSigned', 1, 'propal', '$user->rights->propale->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled && $leftmenu=="propals"', __HANDLER__, 'left', 1106__+MAX_llx_menu__, 'commercial', '', 1102__+MAX_llx_menu__, '/comm/propal/list.php?leftmenu=propals&amp;viewstatut=3', 'PropalStatusNotSigned', 1, 'propal', '$user->rights->propale->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled && $leftmenu=="propals"', __HANDLER__, 'left', 1107__+MAX_llx_menu__, 'commercial', '', 1102__+MAX_llx_menu__, '/comm/propal/list.php?leftmenu=propals&amp;viewstatut=4', 'PropalStatusBilled', 1, 'propal', '$user->rights->propale->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->propal->enabled', __HANDLER__, 'left', 1110__+MAX_llx_menu__, 'commercial', '', 1100__+MAX_llx_menu__, '/comm/propal/stats/index.php?leftmenu=propals', 'Statistics', 1, 'propal', '$user->rights->propale->lire', '', 2, 4, __ENTITY__);
-- Commercial - Customer's orders
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled', __HANDLER__, 'left', 1200__+MAX_llx_menu__, 'commercial', 'orders', 5__+MAX_llx_menu__, '/commande/index.php?leftmenu=orders', 'CustomersOrders', 0, 'orders', '$user->rights->commande->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled', __HANDLER__, 'left', 1201__+MAX_llx_menu__, 'commercial', '', 1200__+MAX_llx_menu__, '/commande/card.php?action=create&amp;leftmenu=orders', 'NewOrder', 1, 'orders', '$user->rights->commande->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled', __HANDLER__, 'left', 1202__+MAX_llx_menu__, 'commercial', '', 1200__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders', 'List', 1, 'orders', '$user->rights->commande->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled && $leftmenu=="orders"', __HANDLER__, 'left', 1203__+MAX_llx_menu__, 'commercial', '', 1202__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=0', 'StatusOrderDraftShort', 1, 'orders', '$user->rights->commande->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled && $leftmenu=="orders"', __HANDLER__, 'left', 1204__+MAX_llx_menu__, 'commercial', '', 1202__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=1', 'StatusOrderValidated', 1, 'orders', '$user->rights->commande->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled && $leftmenu=="orders"', __HANDLER__, 'left', 1205__+MAX_llx_menu__, 'commercial', '', 1202__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=2', 'StatusOrderOnProcessShort', 1, 'orders', '$user->rights->commande->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled && $leftmenu=="orders"', __HANDLER__, 'left', 1206__+MAX_llx_menu__, 'commercial', '', 1202__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=3', 'StatusOrderToBill', 1, 'orders', '$user->rights->commande->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled && $leftmenu=="orders"', __HANDLER__, 'left', 1207__+MAX_llx_menu__, 'commercial', '', 1202__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=4', 'StatusOrderProcessed', 1, 'orders', '$user->rights->commande->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled && $leftmenu=="orders"', __HANDLER__, 'left', 1208__+MAX_llx_menu__, 'commercial', '', 1202__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=-1', 'StatusOrderCanceledShort', 1, 'orders', '$user->rights->commande->lire', '', 2, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled', __HANDLER__, 'left', 1209__+MAX_llx_menu__, 'commercial', '', 1200__+MAX_llx_menu__, '/commande/stats/index.php?leftmenu=orders', 'Statistics', 1, 'orders', '$user->rights->commande->lire', '', 2, 4, __ENTITY__);
-- Commercial - Supplier's orders
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_order->enabled', __HANDLER__, 'left', 5100__+MAX_llx_menu__, 'commercial', 'orders_suppliers', 5__+MAX_llx_menu__, '/fourn/commande/index.php?leftmenu=orders_suppliers', 'SuppliersOrders', 0, 'orders', '$user->rights->fournisseur->commande->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_order->enabled', __HANDLER__, 'left', 5101__+MAX_llx_menu__, 'commercial', '', 5100__+MAX_llx_menu__, '/fourn/commande/card.php?action=create&amp;leftmenu=orders_suppliers', 'NewOrder', 1, 'orders', '$user->rights->fournisseur->commande->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_order->enabled', __HANDLER__, 'left', 5102__+MAX_llx_menu__, 'commercial', '', 5100__+MAX_llx_menu__, '/fourn/commande/list.php?leftmenu=orders_suppliers&amp;viewstatut=0', 'List', 1, 'orders', '$user->rights->fournisseur->commande->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_order->enabled', __HANDLER__, 'left', 5108__+MAX_llx_menu__, 'commercial', '', 5100__+MAX_llx_menu__, '/commande/stats/index.php?leftmenu=orders_suppliers&amp;mode=supplier', 'Statistics', 1, 'orders', '$user->rights->fournisseur->commande->lire', '', 2, 7, __ENTITY__);
-- Commercial - Contracts
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled', __HANDLER__, 'left', 1400__+MAX_llx_menu__, 'commercial', 'contracts', 5__+MAX_llx_menu__, '/contrat/index.php?leftmenu=contracts', 'Contracts', 0, 'contracts', '$user->rights->contrat->lire', '', 2, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled', __HANDLER__, 'left', 1401__+MAX_llx_menu__, 'commercial', '', 1400__+MAX_llx_menu__, '/contrat/card.php?&action=create&amp;leftmenu=contracts', 'NewContract', 1, 'contracts', '$user->rights->contrat->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled', __HANDLER__, 'left', 1402__+MAX_llx_menu__, 'commercial', '', 1400__+MAX_llx_menu__, '/contrat/list.php?leftmenu=contracts', 'List', 1, 'contracts', '$user->rights->contrat->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled', __HANDLER__, 'left', 1403__+MAX_llx_menu__, 'commercial', '', 1400__+MAX_llx_menu__, '/contrat/services.php?leftmenu=contracts', 'MenuServices', 1, 'contracts', '$user->rights->contrat->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled && $leftmenu=="contracts"', __HANDLER__, 'left', 1404__+MAX_llx_menu__, 'commercial', '', 1403__+MAX_llx_menu__, '/contrat/services.php?leftmenu=contracts&amp;mode=0', 'MenuInactiveServices', 2, 'contracts', '$user->rights->contrat->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled && $leftmenu=="contracts"', __HANDLER__, 'left', 1405__+MAX_llx_menu__, 'commercial', '', 1403__+MAX_llx_menu__, '/contrat/services.php?leftmenu=contracts&amp;mode=4', 'MenuRunningServices', 2, 'contracts', '$user->rights->contrat->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled && $leftmenu=="contracts"', __HANDLER__, 'left', 1406__+MAX_llx_menu__, 'commercial', '', 1403__+MAX_llx_menu__, '/contrat/services.php?leftmenu=contracts&amp;mode=4&amp;filter=expired', 'MenuExpiredServices', 2, 'contracts', '$user->rights->contrat->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->contrat->enabled && $leftmenu=="contracts"', __HANDLER__, 'left', 1407__+MAX_llx_menu__, 'commercial', '', 1403__+MAX_llx_menu__, '/contrat/services.php?leftmenu=contracts&amp;mode=5', 'MenuClosedServices', 2, 'contracts', '$user->rights->contrat->lire', '', 2, 3, __ENTITY__);
-- Commercial - Interventions
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->ficheinter->enabled', __HANDLER__, 'left', 1500__+MAX_llx_menu__, 'commercial', 'ficheinter', 5__+MAX_llx_menu__, '/fichinter/list.php?leftmenu=ficheinter', 'Interventions', 0, 'interventions', '$user->rights->ficheinter->lire', '', 2, 8, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->ficheinter->enabled', __HANDLER__, 'left', 1501__+MAX_llx_menu__, 'commercial', '', 1500__+MAX_llx_menu__, '/fichinter/card.php?action=create&amp;leftmenu=ficheinter', 'NewIntervention', 1, 'interventions', '$user->rights->ficheinter->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->ficheinter->enabled', __HANDLER__, 'left', 1502__+MAX_llx_menu__, 'commercial', '', 1500__+MAX_llx_menu__, '/fichinter/list.php?leftmenu=ficheinter', 'List', 1, 'interventions', '$user->rights->ficheinter->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->ficheinter->enabled', __HANDLER__, 'left', 1503__+MAX_llx_menu__, 'commercial', '', 1500__+MAX_llx_menu__, '/fichinter/stats/index.php?leftmenu=ficheinter', 'Statistics', 1, 'interventions', '$user->rights->ficheinter->lire', '', 2, 2, __ENTITY__);
-- Accountancy - Supplier invoice
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_invoice->enabled', __HANDLER__, 'left', 1600__+MAX_llx_menu__, 'accountancy', 'supplier_bills', 6__+MAX_llx_menu__, '/fourn/facture/list.php?leftmenu=suppliers_bills', 'BillsSuppliers', 0, 'bills', '$user->rights->fournisseur->facture->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_invoice->enabled', __HANDLER__, 'left', 1601__+MAX_llx_menu__, 'accountancy', '', 1600__+MAX_llx_menu__, '/fourn/facture/card.php?action=create&amp;leftmenu=suppliers_bills', 'NewBill', 1, 'bills', '$user->rights->fournisseur->facture->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_invoice->enabled', __HANDLER__, 'left', 1602__+MAX_llx_menu__, 'accountancy', '', 1600__+MAX_llx_menu__, '/fourn/facture/list.php?leftmenu=suppliers_bills', 'List', 1, 'bills', '$user->rights->fournisseur->facture->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_invoice->enabled', __HANDLER__, 'left', 1603__+MAX_llx_menu__, 'accountancy', '', 1600__+MAX_llx_menu__, '/fourn/facture/paiement.php?leftmenu=suppliers_bills', 'Payments', 1, 'bills', '$user->rights->fournisseur->facture->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_invoice->enabled', __HANDLER__, 'left', 1605__+MAX_llx_menu__, 'accountancy', '', 1603__+MAX_llx_menu__, '/fourn/facture/rapport.php?leftmenu=suppliers_bills', 'Reporting', 2, 'bills', '$user->rights->fournisseur->facture->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->supplier_invoice->enabled', __HANDLER__, 'left', 1604__+MAX_llx_menu__, 'accountancy', '', 1600__+MAX_llx_menu__, '/compta/facture/stats/index.php?leftmenu=customers_bills&mode=supplier', 'Statistics', 1, 'bills', '$user->rights->fournisseur->facture->lire', '', 2, 8, __ENTITY__);
-- Accountancy - Customer invoice
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1700__+MAX_llx_menu__, 'accountancy', 'customer_bills', 6__+MAX_llx_menu__, '/compta/facture/list.php?leftmenu=customers_bills', 'BillsCustomers', 0, 'bills', '$user->rights->facture->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1701__+MAX_llx_menu__, 'accountancy', '', 1700__+MAX_llx_menu__, '/compta/facture/card.php?action=create&amp;leftmenu=customers_bills', 'NewBill', 1, 'bills', '$user->rights->facture->creer', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1705__+MAX_llx_menu__, 'accountancy', '', 1700__+MAX_llx_menu__, '/compta/facture/list.php?leftmenu=customers_bills', 'List', 1, 'bills', '$user->rights->facture->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1702__+MAX_llx_menu__, 'accountancy', '', 1700__+MAX_llx_menu__, '/compta/facture/fiche-rec.php?leftmenu=customers_bills', 'ListOfTemplates', 1, 'bills', '$user->rights->facture->lire', '', 2, 5, __ENTITY__);

insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1720__+MAX_llx_menu__, 'accountancy', '', 1705__+MAX_llx_menu__, '/compta/facture/list.php?leftmenu=customers_bills&amp;search_status=0', 'BillShortStatusDraft', 2, 'bills', '$user->rights->facture->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1721__+MAX_llx_menu__, 'accountancy', '', 1705__+MAX_llx_menu__, '/compta/facture/list.php?leftmenu=customers_bills&amp;search_status=1', 'BillShortStatusNotPaid', 2, 'bills', '$user->rights->facture->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1722__+MAX_llx_menu__, 'accountancy', '', 1705__+MAX_llx_menu__, '/compta/facture/list.php?leftmenu=customers_bills&amp;search_status=2', 'BillShortStatusPaid', 2, 'bills', '$user->rights->facture->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1723__+MAX_llx_menu__, 'accountancy', '', 1705__+MAX_llx_menu__, '/compta/facture/list.php?leftmenu=customers_bills&amp;search_status=3', 'BillShortStatusCanceled', 2, 'bills', '$user->rights->facture->lire', '', 2, 4, __ENTITY__);

insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1704__+MAX_llx_menu__, 'accountancy', '', 1700__+MAX_llx_menu__, '/compta/paiement/list.php?leftmenu=customers_bills', 'Payments', 1, 'bills', '$user->rights->facture->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1710__+MAX_llx_menu__, 'accountancy', '', 1704__+MAX_llx_menu__, '/compta/paiement/rapport.php?leftmenu=customers_bills', 'Reportings', 2, 'bills', '$user->rights->facture->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->facture->enabled', __HANDLER__, 'left', 1714__+MAX_llx_menu__, 'accountancy', '', 1700__+MAX_llx_menu__, '/compta/facture/stats/index.php?leftmenu=customers_bills', 'Statistics', 1, 'bills', '$user->rights->facture->lire', '', 2, 8, __ENTITY__);
-- Accountancy - Orders to bill
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->commande->enabled', __HANDLER__, 'left', 1900__+MAX_llx_menu__, 'accountancy', 'orders', 6__+MAX_llx_menu__, '/commande/list.php?leftmenu=orders&amp;viewstatut=3', 'MenuOrdersToBill', 0, 'orders', '$user->rights->commande->lire', '', 0, 3, __ENTITY__);
-- Donations
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->don->enabled', __HANDLER__, 'left', 2000__+MAX_llx_menu__, 'accountancy', 'donations', 6__+MAX_llx_menu__, '/don/index.php?leftmenu=donations&amp;mainmenu=accountancy', 'Donations', 0, 'donations', '$user->rights->don->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->don->enabled && $leftmenu=="donations"', __HANDLER__, 'left', 2001__+MAX_llx_menu__, 'accountancy', '', 2000__+MAX_llx_menu__, '/don/card.php?leftmenu=donations&amp;mainmenu=accountancy&amp;action=create', 'NewDonation', 1, 'donations', '$user->rights->don->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->don->enabled && $leftmenu=="donations"', __HANDLER__, 'left', 2002__+MAX_llx_menu__, 'accountancy', '', 2000__+MAX_llx_menu__, '/don/list.php?leftmenu=donations&amp;mainmenu=accountancy', 'List', 1, 'donations', '$user->rights->don->lire', '', 2, 1, __ENTITY__);
-- insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->don->enabled && $leftmenu=="donations"', __HANDLER__, 'left', 2003__+MAX_llx_menu__, 'accountancy', '', 2000__+MAX_llx_menu__, '/don/stats/index.php?leftmenu=donations&amp;mainmenu=accountancy', 'Statistics', 1, 'donations', '$user->rights->don->lire', '', 2, 2, __ENTITY__);
-- Special expenses
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled || $conf->salaries->enabled', __HANDLER__, 'left', 2200__+MAX_llx_menu__, 'accountancy', 'tax', 6__+MAX_llx_menu__, '/compta/charges/index.php?leftmenu=tax&amp;mainmenu=accountancy', 'MenuSpecialExpenses', 0, 'compta', '(! empty($conf->tax->enabled) && $user->rights->tax->charges->lire) || (! empty($conf->salaries->enabled) && $user->rights->salaries->read)', '', 0, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->salaries->enabled', __HANDLER__, 'left', 2210__+MAX_llx_menu__, 'accountancy', 'tax_sal', 2200__+MAX_llx_menu__, '/compta/salaries/index.php?leftmenu=tax_salary&amp;mainmenu=accountancy', 'Salaries', 1, 'salaries', '$user->rights->salaries->payment->read', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->salaries->enabled && $leftmenu=="tax_salary"', __HANDLER__, 'left', 2211__+MAX_llx_menu__, 'accountancy', '', 2210__+MAX_llx_menu__, '/compta/salaries/card.php?leftmenu=tax_salary&amp;action=create', 'NewPayment', 2, 'companies', '$user->rights->salaries->payment->write', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->salaries->enabled && $leftmenu=="tax_salary"', __HANDLER__, 'left', 2212__+MAX_llx_menu__, 'accountancy', '', 2210__+MAX_llx_menu__, '/compta/salaries/index.php?leftmenu=tax_salary', 'Payments', 2, 'companies', '$user->rights->salaries->payment->read', '', 0, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->loan->enabled', __HANDLER__, 'left', 2220__+MAX_llx_menu__, 'accountancy', 'tax_loan', 2200__+MAX_llx_menu__, '/loan/index.php?leftmenu=tax_loan&amp;mainmenu=accountancy', 'Loans', 1, 'loan', '$user->rights->loan->read', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->loan->enabled && $leftmenu=="tax_loan"', __HANDLER__, 'left', 2221__+MAX_llx_menu__, 'accountancy', '', 2220__+MAX_llx_menu__, '/loan/card.php?leftmenu=tax_loan&amp;action=create', 'NewLoan', 2, 'loan', '$user->rights->loan->write', '', 0, 2, __ENTITY__);
--insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->loan->enabled && $leftmenu=="tax_loan"', __HANDLER__, 'left', 2222__+MAX_llx_menu__, 'accountancy', '', 2220__+MAX_llx_menu__, '/loan/payment/list.php?leftmenu=tax_loan', 'Payments', 2, 'companies', '$user->rights->loan->read', '', 0, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->loan->enabled && $leftmenu=="tax_loan" && ! empty($conf->global->LOAN_SHOW_CALCULATOR)', __HANDLER__, 'left', 2223__+MAX_llx_menu__, 'accountancy', '', 2220__+MAX_llx_menu__, '/loan/calc.php?leftmenu=tax_loan', 'Calculator', 2, 'companies', '$user->rights->loan->calc', '', 0, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled', __HANDLER__, 'left', 2250__+MAX_llx_menu__, 'accountancy', 'tax_social', 2200__+MAX_llx_menu__, '/compta/sociales/index.php?leftmenu=tax_social', 'SocialContributions', 1, '', '$user->rights->tax->charges->lire', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && $leftmenu=="tax_social"', __HANDLER__, 'left', 2251__+MAX_llx_menu__, 'accountancy', '', 2250__+MAX_llx_menu__, '/compta/sociales/card.php?leftmenu=tax_social&amp;action=create', 'MenuNewSocialContribution', 2, '', '$user->rights->tax->charges->creer', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && $leftmenu=="tax_social"', __HANDLER__, 'left', 2252__+MAX_llx_menu__, 'accountancy', '', 2250__+MAX_llx_menu__, '/compta/sociales/payments.php?leftmenu=tax_social&amp;mainmenu=accountancy&amp;mode=sconly', 'Payments', 2, '', '$user->rights->tax->charges->lire', '', 0, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && empty($conf->global->TAX_DISABLE_VAT_MENUS)', __HANDLER__, 'left', 2300__+MAX_llx_menu__, 'accountancy', 'tax_vat', 2200__+MAX_llx_menu__, '/compta/tva/index.php?leftmenu=tax_vat&amp;mainmenu=accountancy', 'VAT', 1, 'companies', '$user->rights->tax->charges->lire', '', 0, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && empty($conf->global->TAX_DISABLE_VAT_MENUS) && $leftmenu=="tax_vat"', __HANDLER__, 'left', 2301__+MAX_llx_menu__, 'accountancy', '', 2300__+MAX_llx_menu__, '/compta/tva/card.php?leftmenu=tax_vat&amp;action=create', 'New', 2, 'companies', '$user->rights->tax->charges->creer', '', 0, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && empty($conf->global->TAX_DISABLE_VAT_MENUS) && $leftmenu=="tax_vat"', __HANDLER__, 'left', 2302__+MAX_llx_menu__, 'accountancy', '', 2300__+MAX_llx_menu__, '/compta/tva/reglement.php?leftmenu=tax_vat', 'List', 2, 'companies', '$user->rights->tax->charges->lire', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && empty($conf->global->TAX_DISABLE_VAT_MENUS) && $leftmenu=="tax_vat"', __HANDLER__, 'left', 2303__+MAX_llx_menu__, 'accountancy', '', 2300__+MAX_llx_menu__, '/compta/tva/clients.php?leftmenu=tax_vat', 'ReportByCustomers', 2, 'companies', '$user->rights->tax->charges->lire', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->tax->enabled && empty($conf->global->TAX_DISABLE_VAT_MENUS) && $leftmenu=="tax_vat"', __HANDLER__, 'left', 2304__+MAX_llx_menu__, 'accountancy', '', 2300__+MAX_llx_menu__, '/compta/tva/quadri_detail.php?leftmenu=tax_vat', 'ReportByQuarter', 2, 'companies', '$user->rights->tax->charges->lire', '', 0, 3, __ENTITY__);
-- Accounting Expert
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2400__+MAX_llx_menu__, 'accountancy', 'accounting', 6__+MAX_llx_menu__, '/accountancy/index.php?leftmenu=accountancy', 'MenuAccountancy', 0, 'accountancy', '! empty($conf->accounting->enabled) || $user->rights->accounting->bind->write || $user->rights->accounting->bind->write || $user->rights->compta->resultat->lire', '', 0, 7, __ENTITY__);
	-- Setup
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2451__+MAX_llx_menu__, 'accountancy', 'accountancy_admin',            2400__+MAX_llx_menu__, '/accountancy/index.php?mainmenu=accountancy&leftmenu=accountancy_admin', 'Setup', 1, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 1, __ENTITY__);

	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2454__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_journal',       2451__+MAX_llx_menu__, '/accountancy/admin/journals_list.php?id=35&mainmenu=accountancy&leftmenu=accountancy_admin', 'AccountingJournals', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 10, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2455__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_chartmodel',    2451__+MAX_llx_menu__, '/accountancy/admin/account.php?mainmenu=accountancy&leftmenu=accountancy_admin', 'Pcg_version', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 20, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2456__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_chart',         2451__+MAX_llx_menu__, '/accountancy/admin/account.php?mainmenu=accountancy&leftmenu=accountancy_admin', 'Chartofaccounts', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 30, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2457__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_chart_group',   2451__+MAX_llx_menu__, '/accountancy/admin/categories_list.php?id=32&mainmenu=accountancy&leftmenu=accountancy_admin', 'AccountingCategory', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 40, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2458__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_default',       2451__+MAX_llx_menu__, '/accountancy/admin/defaultaccounts.php?mainmenu=accountancy&leftmenu=accountancy_admin', 'MenuDefaultAccounts', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 50, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2459__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_vat',           2451__+MAX_llx_menu__, '/admin/dict.php?id=10&from=accountancy&search_country_id=__MYCOUNTRYID__&mainmenu=accountancy&leftmenu=accountancy_admin', 'MenuVatAccounts', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 60, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2460__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_tax',           2451__+MAX_llx_menu__, '/admin/dict.php?id=7&from=accountancy&search_country_id=__MYCOUNTRYID__&mainmenu=accountancy&leftmenu=accountancy_admin', 'MenuTaxAccounts', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 70, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->expensereport->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2461__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_expensereport', 2451__+MAX_llx_menu__, '/admin/dict.php?id=17&from=accountancy&mainmenu=accountancy&leftmenu=accountancy_admin', 'MenuExpenseReportAccounts', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 80, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin"', __HANDLER__, 'left', 2462__+MAX_llx_menu__, 'accountancy', 'accountancy_admin_product',       2451__+MAX_llx_menu__, '/accountancy/admin/productaccount.php?mainmenu=accountancy&leftmenu=accountancy_admin', 'MenuProductsAccounts', 2, 'accountancy', '$user->rights->accounting->chartofaccount', '', 0, 90, __ENTITY__);
	-- Accounting period
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy_admin" && $conf->global->MAIN_FEATURES_LEVEL > 0', __HANDLER__, 'left', 2450__+MAX_llx_menu__,  'accountancy', 'accountancy_admin_period', 2451__+MAX_llx_menu__, '/accountancy/admin/fiscalyear.php?mainmenu=accountancy&leftmenu=accountancy_admin', 'FiscalPeriod', 1, 'admin', '', '', 2, 80, __ENTITY__);
	-- Binding
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2401__+MAX_llx_menu__, 'accountancy', 'dispatch_customer', 2400__+MAX_llx_menu__, '/accountancy/customer/index.php?leftmenu=dispatch_customer', 'CustomersVentilation', 1, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 2, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="dispatch_customer"', __HANDLER__, 'left', 2402__+MAX_llx_menu__, 'accountancy', '', 2401__+MAX_llx_menu__, '/accountancy/customer/list.php', 'ToDispatch', 2, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 3, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="dispatch_customer"', __HANDLER__, 'left', 2403__+MAX_llx_menu__, 'accountancy', '', 2401__+MAX_llx_menu__, '/accountancy/customer/lines.php', 'Dispatched', 2, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 4, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->fournisseur->enabled', __HANDLER__, 'left', 2410__+MAX_llx_menu__, 'accountancy', 'ventil_supplier', 2400__+MAX_llx_menu__, '/accountancy/supplier/index.php?leftmenu=dispatch_supplier', 'SuppliersVentilation', 1, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 5, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->fournisseur->enabled && $leftmenu=="dispatch_supplier"', __HANDLER__, 'left', 2411__+MAX_llx_menu__, 'accountancy', '', 2410__+MAX_llx_menu__, '/accountancy/supplier/list.php', 'ToDispatch', 2, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 6, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->fournisseur->enabled && $leftmenu=="dispatch_supplier"', __HANDLER__, 'left', 2412__+MAX_llx_menu__, 'accountancy', '', 2410__+MAX_llx_menu__, '/accountancy/supplier/lines.php', 'Dispatched', 2, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 7, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->expensereport->enabled', __HANDLER__, 'left', 2420__+MAX_llx_menu__, 'accountancy', 'ventil_expensereport', 2400__+MAX_llx_menu__, '/accountancy/expensereport/index.php?leftmenu=dispatch_expensereport', 'ExpenseReportsVentilation', 1, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 5, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->expensereport->enabled && $leftmenu=="dispatch_expensereport"', __HANDLER__, 'left', 2421__+MAX_llx_menu__, 'accountancy', '', 2420__+MAX_llx_menu__, '/accountancy/expensereport/list.php', 'ToDispatch', 2, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 6, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $conf->expensereport->enabled && $leftmenu=="dispatch_expensereport"', __HANDLER__, 'left', 2422__+MAX_llx_menu__, 'accountancy', '', 2420__+MAX_llx_menu__, '/accountancy/expensereport/lines.php', 'Dispatched', 2, 'accountancy', '$user->rights->accounting->bind->write', '', 0, 7, __ENTITY__);
	-- Journals
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2705__+MAX_llx_menu__, 'accountancy', '', 2400__+MAX_llx_menu__, '', 'Journalization', 1, 'main', '$user->rights->accounting->comptarapport->lire', '', 0, 1, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2707__+MAX_llx_menu__, 'accountancy', '', 2705__+MAX_llx_menu__, '/accountancy/journal/bankjournal.php?mainmenu=accountancy&leftmenu=accountancy_journal&id_journal=3', 'BankJournal', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 1, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2708__+MAX_llx_menu__, 'accountancy', '', 2705__+MAX_llx_menu__, '/accountancy/journal/expensereportsjournal.php?mainmenu=accountancy&leftmenu=accountancy_journal&id_journal=6', 'ExpenseReportJournal', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 2, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2709__+MAX_llx_menu__, 'accountancy', '', 2705__+MAX_llx_menu__, '/accountancy/journal/purchasesjournal.php?mainmenu=accountancy&leftmenu=accountancy_journal&id_journal=2', 'PurchasesJournal', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 3, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2706__+MAX_llx_menu__, 'accountancy', '', 2705__+MAX_llx_menu__, '/accountancy/journal/sellsjournal.php?mainmenu=accountancy&leftmenu=accountancy_journal&id_journal=1', 'SellsJournal', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 4, __ENTITY__);
	-- General Ledger
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2430__+MAX_llx_menu__, 'accountancy', 'bookkeeping', 2400__+MAX_llx_menu__, '/accountancy/bookkeeping/list.php', 'Bookkeeping', 1, 'accountancy', '$user->rights->accounting->mouvements->lire', '', 0, 15, __ENTITY__);
	-- Balance
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2435__+MAX_llx_menu__, 'accountancy', 'balance', 2400__+MAX_llx_menu__, '/accountancy/bookkeeping/balance.php', 'AccountBalance', 1, 'accountancy', '$user->rights->accounting->mouvements->lire', '', 0, 16, __ENTITY__);
	-- Reports
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled', __HANDLER__, 'left', 2440__+MAX_llx_menu__, 'accountancy', 'report', 2400__+MAX_llx_menu__, '/accountancy/report/result.php?mainmenu=accountancy&leftmenu=accountancy', 'Reportings', 1, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 17, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2441__+MAX_llx_menu__, 'accountancy', '', 2440__+MAX_llx_menu__, '/compta/resultat/index.php?mainmenu=accountancy&leftmenu=accountancy', 'ReportInOut', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 19, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2442__+MAX_llx_menu__, 'accountancy', '', 2441__+MAX_llx_menu__, '/accountancy/report/result.php?mainmenu=accountancy&leftmenu=accountancy', 'ByAccounts', 3, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 18, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2443__+MAX_llx_menu__, 'accountancy', '', 2441__+MAX_llx_menu__, '/compta/resultat/clientfourn.php?mainmenu=accountancy&leftmenu=accountancy', 'ByCompanies', 3, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 20, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2444__+MAX_llx_menu__, 'accountancy', '', 2440__+MAX_llx_menu__, '/compta/stats/index.php?mainmenu=accountancy&leftmenu=accountancy', 'ReportTurnover', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 21, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2445__+MAX_llx_menu__, 'accountancy', '', 2444__+MAX_llx_menu__, '/compta/stats/casoc.php?mainmenu=accountancy&leftmenu=accountancy', 'ByCompanies', 3, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 22, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2446__+MAX_llx_menu__, 'accountancy', '', 2444__+MAX_llx_menu__, '/compta/stats/cabyuser.php?mainmenu=accountancy&leftmenu=accountancy', 'ByUsers', 3, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 23, __ENTITY__);
	insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->accounting->enabled && $leftmenu=="accountancy"', __HANDLER__, 'left', 2447__+MAX_llx_menu__, 'accountancy', '', 2444__+MAX_llx_menu__, '/compta/stats/cabyprodserv.php?mainmenu=accountancy&leftmenu=accountancy', 'ByProductsAndServices', 3, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 24, __ENTITY__);
-- Rapports compta simple
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled', __HANDLER__, 'left', 2700__+MAX_llx_menu__, 'accountancy', 'ca', 6__+MAX_llx_menu__, '/compta/resultat/index.php?leftmenu=ca&amp;mainmenu=accountancy', 'Reportings', 0, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 11, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled && $leftmenu=="ca"', __HANDLER__, 'left', 2711__+MAX_llx_menu__, 'accountancy', '', 2700__+MAX_llx_menu__, '/compta/resultat/index.php?leftmenu=ca', 'ReportInOut', 1, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled && $leftmenu=="ca"', __HANDLER__, 'left', 2712__+MAX_llx_menu__, 'accountancy', '', 2701__+MAX_llx_menu__, '/compta/resultat/clientfourn.php?leftmenu=ca', 'ByCompanies', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled && $leftmenu=="ca"', __HANDLER__, 'left', 2713__+MAX_llx_menu__, 'accountancy', '', 2700__+MAX_llx_menu__, '/compta/stats/index.php?leftmenu=ca', 'ReportTurnover', 1, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled && $leftmenu=="ca"', __HANDLER__, 'left', 2714__+MAX_llx_menu__, 'accountancy', '', 2703__+MAX_llx_menu__, '/compta/stats/casoc.php?leftmenu=ca', 'ByCompanies', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled && $leftmenu=="ca"', __HANDLER__, 'left', 2715__+MAX_llx_menu__, 'accountancy', '', 2703__+MAX_llx_menu__, '/compta/stats/cabyuser.php?leftmenu=ca', 'ByUsers', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->comptabilite->enabled && $leftmenu=="ca"', __HANDLER__, 'left', 2716__+MAX_llx_menu__, 'accountancy', '', 2703__+MAX_llx_menu__, '/compta/stats/cabyprodserv.php?leftmenu=ca', 'ByProductsAndServices', 2, 'main', '$user->rights->compta->resultat->lire || $user->rights->accounting->comptarapport->lire', '', 0, 1, __ENTITY__);
-- Check deposit
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', 'empty($conf->global->BANK_DISABLE_CHECK_DEPOSIT) && ! empty($conf->banque->enabled) && (! empty($conf->facture->enabled) || ! empty($conf->global->MAIN_MENU_CHEQUE_DEPOSIT_ON))', __HANDLER__, 'left', 1711__+MAX_llx_menu__, 'accountancy', 'checks', 14__+MAX_llx_menu__, '/compta/paiement/cheque/index.php?leftmenu=checks&amp;mainmenu=bank', 'MenuChequeDeposits', 0, 'bills', '$user->rights->banque->lire', '', 2, 9, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', 'empty($conf->global->BANK_DISABLE_CHECK_DEPOSIT) && ! empty($conf->banque->enabled) && (! empty($conf->facture->enabled) || ! empty($conf->global->MAIN_MENU_CHEQUE_DEPOSIT_ON))', __HANDLER__, 'left', 1712__+MAX_llx_menu__, 'accountancy', '', 1711__+MAX_llx_menu__, '/compta/paiement/cheque/card.php?leftmenu=checks&amp;action=new', 'NewCheckDeposit', 1, 'compta', '$user->rights->banque->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', 'empty($conf->global->BANK_DISABLE_CHECK_DEPOSIT) && ! empty($conf->banque->enabled) && (! empty($conf->facture->enabled) || ! empty($conf->global->MAIN_MENU_CHEQUE_DEPOSIT_ON))', __HANDLER__, 'left', 1713__+MAX_llx_menu__, 'accountancy', '', 1711__+MAX_llx_menu__, '/compta/paiement/cheque/list.php?leftmenu=checks', 'List', 1, 'bills', '$user->rights->banque->lire', '', 2, 1, __ENTITY__);
-- Withdrawal
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->prelevement->enabled', __HANDLER__, 'left', 2500__+MAX_llx_menu__, 'accountancy', 'withdraw', 14__+MAX_llx_menu__, '/compta/prelevement/index.php?leftmenu=withdraw&amp;mainmenu=bank', 'StandingOrders', 0, 'withdrawals', '$user->rights->prelevement->bons->lire', '', 2, 9, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->prelevement->enabled && $leftmenu=="withdraw"', __HANDLER__, 'left', 2502__+MAX_llx_menu__, 'accountancy', '', 2500__+MAX_llx_menu__, '/compta/prelevement/create.php?leftmenu=withdraw', 'NewStandingOrder', 1, 'withdrawals', '$user->rights->prelevement->bons->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->prelevement->enabled && $leftmenu=="withdraw"', __HANDLER__, 'left', 2503__+MAX_llx_menu__, 'accountancy', '', 2500__+MAX_llx_menu__, '/compta/prelevement/bons.php?leftmenu=withdraw', 'WithdrawalsReceipts', 1, 'withdrawals', '$user->rights->prelevement->bons->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->prelevement->enabled && $leftmenu=="withdraw"', __HANDLER__, 'left', 2504__+MAX_llx_menu__, 'accountancy', '', 2500__+MAX_llx_menu__, '/compta/prelevement/list.php?leftmenu=withdraw', 'WithdrawalsLines', 1, 'withdrawals', '$user->rights->prelevement->bons->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->prelevement->enabled && $leftmenu=="withdraw"', __HANDLER__, 'left', 2506__+MAX_llx_menu__, 'accountancy', '', 2500__+MAX_llx_menu__, '/compta/prelevement/rejets.php?leftmenu=withdraw', 'Rejects', 1, 'withdrawals', '$user->rights->prelevement->bons->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->prelevement->enabled && $leftmenu=="withdraw"', __HANDLER__, 'left', 2507__+MAX_llx_menu__, 'accountancy', '', 2500__+MAX_llx_menu__, '/compta/prelevement/stats.php?leftmenu=withdraw', 'Statistics', 1, 'withdrawals', '$user->rights->prelevement->bons->lire', '', 2, 6, __ENTITY__);
-- Bank
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->banque->enabled', __HANDLER__, 'left', 2600__+MAX_llx_menu__, 'accountancy', 'bank', 14__+MAX_llx_menu__, '/compta/bank/index.php?leftmenu=bank&amp;mainmenu=bank', 'MenuBankCash', 0, 'banks', '$user->rights->banque->lire', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->banque->enabled && ($leftmenu=="bank" || $leftmenu=="checks" || $leftmenu=="withdraw")', __HANDLER__, 'left', 2601__+MAX_llx_menu__, 'accountancy', '', 2600__+MAX_llx_menu__, '/compta/bank/card.php?action=create&amp;leftmenu=bank', 'MenuNewFinancialAccount', 1, 'banks', '$user->rights->banque->configurer', '', 0, 0, __ENTITY__);
-- insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->banque->enabled && ($leftmenu=="bank" || $leftmenu=="checks" || $leftmenu=="withdraw")', __HANDLER__, 'left', 2602__+MAX_llx_menu__, 'accountancy', '', 2600__+MAX_llx_menu__, '/compta/bank/categ.php?leftmenu=bank', 'Rubriques', 1, 'categories', '$user->rights->banque->configurer', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->banque->enabled && ($leftmenu=="bank" || $leftmenu=="checks" || $leftmenu=="withdraw")', __HANDLER__, 'left', 2603__+MAX_llx_menu__, 'accountancy', '', 2600__+MAX_llx_menu__, '/compta/bank/bankentries.php?leftmenu=bank', 'ListTransactions', 1, 'banks', '$user->rights->banque->lire', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->banque->enabled && ($leftmenu=="bank" || $leftmenu=="checks" || $leftmenu=="withdraw")', __HANDLER__, 'left', 2604__+MAX_llx_menu__, 'accountancy', '', 2600__+MAX_llx_menu__, '/compta/bank/budget.php?leftmenu=bank', 'ListTransactionsByCategory', 1, 'banks', '$user->rights->banque->lire', '', 0, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->banque->enabled && ($leftmenu=="bank" || $leftmenu=="checks" || $leftmenu=="withdraw")', __HANDLER__, 'left', 2606__+MAX_llx_menu__, 'accountancy', '', 2600__+MAX_llx_menu__, '/compta/bank/transfer.php?leftmenu=bank', 'BankTransfers', 1, 'banks', '$user->rights->banque->transfer', '', 0, 5, __ENTITY__);
-- Bank - Categories
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->categorie->enabled', __HANDLER__, 'left', 2650__+MAX_llx_menu__, 'accountancy', 'cat', 14__+MAX_llx_menu__, '/categories/index.php?leftmenu=bank&amp;type=5', 'Categories', 0, 'categories', '$user->rights->categorie->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->categorie->enabled', __HANDLER__, 'left', 2651__+MAX_llx_menu__, 'accountancy', '', 2650__+MAX_llx_menu__, '/categories/card.php?leftmenu=bank&amp;action=create&amp;type=5', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- Project
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled', __HANDLER__, 'left', 3600__+MAX_llx_menu__, 'project', 'projects', 7__+MAX_llx_menu__, '/projet/index.php?leftmenu=projects', 'Projects', 0, 'projects', '$user->rights->projet->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled', __HANDLER__, 'left', 3601__+MAX_llx_menu__, 'project', '', 3600__+MAX_llx_menu__, '/projet/card.php?leftmenu=projects&amp;action=create', 'NewProject', 1, 'projects', '$user->rights->projet->creer', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled', __HANDLER__, 'left', 3602__+MAX_llx_menu__, 'project', '', 3600__+MAX_llx_menu__, '/projet/list.php?leftmenu=projects', 'List', 1, 'projects', '$user->rights->projet->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled', __HANDLER__, 'left', 3603__+MAX_llx_menu__, 'project', '', 3600__+MAX_llx_menu__, '/projet/stats/index.php?leftmenu=projects', 'Statistics', 1, 'projects', '$user->rights->projet->lire', '', 2, 3, __ENTITY__);

insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled && $conf->global->PROJECT_USE_TASKS', __HANDLER__, 'left', 3700__+MAX_llx_menu__, 'project', '', 7__+MAX_llx_menu__, '/projet/activity/index.php?leftmenu=projects', 'Activities', 0, 'projects', '$user->rights->projet->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled && $conf->global->PROJECT_USE_TASKS', __HANDLER__, 'left', 3701__+MAX_llx_menu__, 'project', '', 3700__+MAX_llx_menu__, '/projet/tasks.php?leftmenu=projects&amp;action=create', 'NewTask', 1, 'projects', '$user->rights->projet->creer', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled && $conf->global->PROJECT_USE_TASKS', __HANDLER__, 'left', 3702__+MAX_llx_menu__, 'project', '', 3700__+MAX_llx_menu__, '/projet/tasks/list.php?leftmenu=projects', 'List', 1, 'projects', '$user->rights->projet->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled && $conf->global->PROJECT_USE_TASKS', __HANDLER__, 'left', 3704__+MAX_llx_menu__, 'project', '', 3700__+MAX_llx_menu__, '/projet/tasks/stats/index.php?leftmenu=projects', 'Statistics', 1, 'projects', '$user->rights->projet->lire', '', 2, 4, __ENTITY__);

insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->projet->enabled && $conf->global->PROJECT_USE_TASKS', __HANDLER__, 'left', 3400__+MAX_llx_menu__, 'project', '', 7__+MAX_llx_menu__, '/projet/activity/perweek.php?leftmenu=projects', 'NewTimeSpent', 0, 'projects', '$user->rights->projet->lire', '', 2, 3, __ENTITY__);

-- Project - Categories
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->categorie->enabled', __HANDLER__, 'left', 3804__+MAX_llx_menu__, 'project', 'cat', 7__+MAX_llx_menu__, '/categories/index.php?leftmenu=cat&amp;type=6', 'Categories', 0, 'categories', '$user->rights->categorie->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->categorie->enabled', __HANDLER__, 'left', 3805__+MAX_llx_menu__, 'project', '', 3804__+MAX_llx_menu__, '/categories/card.php?action=create&amp;type=6', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- Tools
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->mailing->enabled', __HANDLER__, 'left', 3900__+MAX_llx_menu__, 'tools', 'mailing', 8__+MAX_llx_menu__, '/comm/mailing/index.php?leftmenu=mailing', 'EMailings', 0, 'mails', '$user->rights->mailing->lire', '', 0, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->mailing->enabled', __HANDLER__, 'left', 3901__+MAX_llx_menu__, 'tools', '', 3900__+MAX_llx_menu__, '/comm/mailing/card.php?leftmenu=mailing&amp;action=create', 'NewMailing', 1, 'mails', '$user->rights->mailing->creer', '', 0, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->mailing->enabled', __HANDLER__, 'left', 3902__+MAX_llx_menu__, 'tools', '', 3900__+MAX_llx_menu__, '/comm/mailing/list.php?leftmenu=mailing', 'List', 1, 'mails', '$user->rights->mailing->lire', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->export->enabled', __HANDLER__, 'left', 4100__+MAX_llx_menu__, 'tools', 'export', 8__+MAX_llx_menu__, '/exports/index.php?leftmenu=export', 'FormatedExport', 0, 'exports', '$user->rights->export->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->export->enabled', __HANDLER__, 'left', 4101__+MAX_llx_menu__, 'tools', '', 4100__+MAX_llx_menu__, '/exports/export.php?leftmenu=export', 'NewExport', 1, 'exports', '$user->rights->export->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->import->enabled', __HANDLER__, 'left', 4130__+MAX_llx_menu__, 'tools', 'import', 8__+MAX_llx_menu__, '/imports/index.php?leftmenu=import', 'FormatedImport', 0, 'exports', '$user->rights->import->run', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->import->enabled', __HANDLER__, 'left', 4131__+MAX_llx_menu__, 'tools', '', 4130__+MAX_llx_menu__, '/imports/import.php?leftmenu=import', 'NewImport', 1, 'exports', '$user->rights->import->run', '', 2, 0, __ENTITY__);
-- Members
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4200__+MAX_llx_menu__, 'members', 'members', 13__+MAX_llx_menu__, '/adherents/index.php?leftmenu=members&amp;mainmenu=members', 'Members', 0, 'members', '$user->rights->adherent->lire', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4201__+MAX_llx_menu__, 'members', '', 4200__+MAX_llx_menu__, '/adherents/card.php?leftmenu=members&amp;action=create', 'NewMember', 1, 'members', '$user->rights->adherent->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4202__+MAX_llx_menu__, 'members', '', 4200__+MAX_llx_menu__, '/adherents/list.php', 'List', 1, 'members', '$user->rights->adherent->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4203__+MAX_llx_menu__, 'members', '', 4202__+MAX_llx_menu__, '/adherents/list.php?leftmenu=members&amp;statut=-1', 'MenuMembersToValidate', 2, 'members', '$user->rights->adherent->lire', '', 2, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4204__+MAX_llx_menu__, 'members', '', 4202__+MAX_llx_menu__, '/adherents/list.php?leftmenu=members&amp;statut=1', 'MenuMembersValidated', 2, 'members', '$user->rights->adherent->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4205__+MAX_llx_menu__, 'members', '', 4202__+MAX_llx_menu__, '/adherents/list.php?leftmenu=members&amp;statut=1&amp;filter=outofdate', 'MenuMembersNotUpToDate', 2, 'members', '$user->rights->adherent->lire', '', 2, 4, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4206__+MAX_llx_menu__, 'members', '', 4202__+MAX_llx_menu__, '/adherents/list.php?leftmenu=members&amp;statut=1&amp;filter=uptodate', 'MenuMembersUpToDate', 2, 'members', '$user->rights->adherent->lire', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4207__+MAX_llx_menu__, 'members', '', 4202__+MAX_llx_menu__, '/adherents/list.php?leftmenu=members&amp;statut=0', 'MenuMembersResiliated', 2, 'members', '$user->rights->adherent->lire', '', 2, 6, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4208__+MAX_llx_menu__, 'members', '', 4200__+MAX_llx_menu__, '/adherents/stats/geo.php?leftmenu=members&amp;mode=memberbycountry', 'MenuMembersStats', 1, 'members', '$user->rights->adherent->lire', '', 2, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '! empty($conf->global->MEMBER_LINK_TO_HTPASSWDFILE) && $conf->adherent->enabled', __HANDLER__, 'left', 4502__+MAX_llx_menu__, 'members', '', 4200__+MAX_llx_menu__, '/adherents/htpasswd.php?leftmenu=export', 'Filehtpasswd', 1, 'members', '$user->rights->adherent->export', '', 2, 9, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4503__+MAX_llx_menu__, 'members', '', 4200__+MAX_llx_menu__, '/adherents/cartes/carte.php?leftmenu=export', 'MembersCards', 1, 'members', '$user->rights->adherent->export', '', 2, 10, __ENTITY__);
-- Members - Subscriptions
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4300__+MAX_llx_menu__, 'members', '', 13__+MAX_llx_menu__, '/adherents/index.php?leftmenu=members&amp;mainmenu=members', 'Subscriptions', 0, 'compta', '$user->rights->adherent->cotisation->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4301__+MAX_llx_menu__, 'members', '', 4300__+MAX_llx_menu__, '/adherents/list.php?statut=-1&amp;leftmenu=accountancy&amp;mainmenu=members', 'NewSubscription', 1, 'compta', '$user->rights->adherent->cotisation->creer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4302__+MAX_llx_menu__, 'members', '', 4300__+MAX_llx_menu__, '/adherents/subscription/list.php?leftmenu=members', 'List', 1, 'compta', '$user->rights->adherent->cotisation->lire', '', 2, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4303__+MAX_llx_menu__, 'members', '', 4300__+MAX_llx_menu__, '/adherents/stats/index.php?leftmenu=members', 'MenuMembersStats', 1, 'members', '$user->rights->adherent->lire', '', 2, 7, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4700__+MAX_llx_menu__, 'members', 'setup', 13__+MAX_llx_menu__, '/adherents/type.php?leftmenu=setup&amp;mainmenu=members', 'MembersTypes', 0, 'members', '$user->rights->adherent->configurer', '', 2, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4701__+MAX_llx_menu__, 'members', '', 4700__+MAX_llx_menu__, '/adherents/type.php?leftmenu=setup&amp;mainmenu=members&amp;action=create', 'New', 1, 'members', '$user->rights->adherent->configurer', '', 2, 0, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled', __HANDLER__, 'left', 4702__+MAX_llx_menu__, 'members', '', 4700__+MAX_llx_menu__, '/adherents/type.php?leftmenu=setup&amp;mainmenu=members', 'List', 1, 'members', '$user->rights->adherent->configurer', '', 2, 1, __ENTITY__);
-- Members - Category member
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 5200__+MAX_llx_menu__, 'members', 'cat', 13__+MAX_llx_menu__, '/categories/index.php?leftmenu=cat&amp;type=3', 'MembersCategoriesShort', 0, 'categories', '$user->rights->categorie->lire', '', 2, 3, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->adherent->enabled && $conf->categorie->enabled', __HANDLER__, 'left', 5201__+MAX_llx_menu__, 'members', '', 5200__+MAX_llx_menu__, '/categories/card.php?action=create&amp;type=3', 'NewCategory', 1, 'categories', '$user->rights->categorie->creer', '', 2, 0, __ENTITY__);
-- HRM - Employee
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->hrm->enabled', __HANDLER__, 'left', 4600__+MAX_llx_menu__, 'hrm', 'hrm', 15__+MAX_llx_menu__, '/user/index.php?leftmenu=hrm&mode=employee', 'Employees', 0, 'hrm', '$user->rights->hrm->employee->read', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->hrm->enabled', __HANDLER__, 'left', 4601__+MAX_llx_menu__, 'hrm', '', 4600__+MAX_llx_menu__, '/user/card.php?action=create&employee=1', 'NewEmployee', 1, 'hrm', '$user->rights->hrm->employee->write', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->hrm->enabled', __HANDLER__, 'left', 4602__+MAX_llx_menu__, 'hrm', '', 4600__+MAX_llx_menu__, '/user/index.php?$leftmenu=hrm&mode=employee&contextpage=employeelist', 'List', 1, 'hrm', '$user->rights->hrm->employee->read', '', 0, 2, __ENTITY__);
-- HRM - Holiday
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->holiday->enabled', __HANDLER__, 'left', 5000__+MAX_llx_menu__, 'hrm', 'hrm', 15__+MAX_llx_menu__, '/holiday/list.php?&leftmenu=hrm', 'CPTitreMenu', 0, 'holiday', '$user->rights->holiday->read', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->holiday->enabled', __HANDLER__, 'left', 5001__+MAX_llx_menu__, 'hrm', '', 5000__+MAX_llx_menu__, '/holiday/card.php?&action=request', 'MenuAddCP', 1, 'holiday', '$user->rights->holiday->write', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->holiday->enabled', __HANDLER__, 'left', 5002__+MAX_llx_menu__, 'hrm', '', 5000__+MAX_llx_menu__, '/holiday/list.php?&leftmenu=hrm', 'List', 1, 'holiday', '$user->rights->holiday->read', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->holiday->enabled', __HANDLER__, 'left', 5003__+MAX_llx_menu__, 'hrm', '', 5002__+MAX_llx_menu__, '/holiday/list.php?select_statut=2&leftmenu=hrm', 'ListToApprove', 2, 'trips', '$user->rights->holiday->read', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->holiday->enabled', __HANDLER__, 'left', 5004__+MAX_llx_menu__, 'hrm', '', 5000__+MAX_llx_menu__, '/holiday/define_holiday.php?&action=request', 'MenuConfCP', 1, 'holiday', '$user->rights->holiday->define_holiday', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->holiday->enabled', __HANDLER__, 'left', 5005__+MAX_llx_menu__, 'hrm', '', 5000__+MAX_llx_menu__, '/holiday/view_log.php?&action=request', 'MenuLogCP', 1, 'holiday', '$user->rights->holiday->define_holiday', '', 0, 3, __ENTITY__);
-- HRM - Trips and expenses (old module)
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->deplacement->enabled', __HANDLER__, 'left', 2100__+MAX_llx_menu__, 'accountancy', 'tripsandexpenses', 15__+MAX_llx_menu__, '/compta/deplacement/index.php?leftmenu=tripsandexpenses', 'TripsAndExpenses', 0, 'trips', '$user->rights->deplacement->lire', '', 0, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->deplacement->enabled', __HANDLER__, 'left', 2101__+MAX_llx_menu__, 'accountancy', '', 2100__+MAX_llx_menu__, '/compta/deplacement/card.php?action=create&amp;leftmenu=tripsandexpenses', 'New', 1, 'trips', '$user->rights->deplacement->creer', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->deplacement->enabled', __HANDLER__, 'left', 2102__+MAX_llx_menu__, 'accountancy', '', 2100__+MAX_llx_menu__, '/compta/deplacement/list.php?leftmenu=tripsandexpenses', 'List', 1, 'trips', '$user->rights->deplacement->lire', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->deplacement->enabled', __HANDLER__, 'left', 2103__+MAX_llx_menu__, 'accountancy', '', 2100__+MAX_llx_menu__, '/compta/deplacement/stats/index.php?leftmenu=tripsandexpenses', 'Statistics', 1, 'trips', '$user->rights->deplacement->lire', '', 0, 2, __ENTITY__);
-- HRM - Expense reports
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expensereport->enabled', __HANDLER__, 'left', 5300__+MAX_llx_menu__, 'hrm', 'expensereport', 15__+MAX_llx_menu__, '/expensereport/index.php?leftmenu=expensereport', 'TripsAndExpenses', 0, 'trips', '$user->rights->expensereport->lire', '', 0, 5, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expensereport->enabled', __HANDLER__, 'left', 5301__+MAX_llx_menu__, 'hrm', '', 5300__+MAX_llx_menu__, '/expensereport/card.php?action=create&amp;leftmenu=expensereport', 'New', 1, 'trips', '$user->rights->expensereport->creer', '', 0, 1, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expensereport->enabled', __HANDLER__, 'left', 5302__+MAX_llx_menu__, 'hrm', '', 5300__+MAX_llx_menu__, '/expensereport/list.php?leftmenu=expensereport', 'List', 1, 'trips', '$user->rights->expensereport->lire', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expensereport->enabled', __HANDLER__, 'left', 5303__+MAX_llx_menu__, 'hrm', '', 5302__+MAX_llx_menu__, '/expensereport/list.php?search_status=2&amp;leftmenu=expensereport', 'ListToApprove', 2, 'trips', '$user->rights->expensereport->approve', '', 0, 2, __ENTITY__);
insert into llx_menu (module, enabled, menu_handler, type, rowid, mainmenu, leftmenu, fk_menu, url, titre, level, langs, perms, target, usertype, position, entity) values ('', '$conf->expensereport->enabled', __HANDLER__, 'left', 5304__+MAX_llx_menu__, 'hrm', '', 5300__+MAX_llx_menu__, '/expensereport/stats/index.php?leftmenu=expensereport', 'Statistics', 1, 'trips', '$user->rights->expensereport->lire', '', 0, 2, __ENTITY__);
