<?php
/* Copyright (C) 2007-2016	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2009-2017	Regis Houssin		<regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       htdocs/admin/translation.php
 *       \brief      Page to show translation information
 */

require '../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formadmin.class.php';

$langs->load("companies");
$langs->load("products");
$langs->load("admin");
$langs->load("sms");
$langs->load("other");
$langs->load("errors");

if (!$user->admin) accessforbidden();

$id=GETPOST('rowid','int');
$action=GETPOST('action','alpha');

$langcode=GETPOST('langcode','alpha');
$transkey=GETPOST('transkey','alpha');
$transvalue=GETPOST('transvalue','alpha');


$mode = GETPOST('mode')?GETPOST('mode'):'overwrite';

$limit = GETPOST('limit','int')?GETPOST('limit','int'):$conf->liste_limit;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
if (empty($page) || $page == -1) { $page = 0; }     // If $page is not defined, or '' or -1
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
if (! $sortfield) $sortfield='lang,transkey';
if (! $sortorder) $sortorder='ASC';

// Initialize technical object to manage hooks of page. Note that conf->hooks_modules contains array of hook context
$hookmanager->initHooks(array('admintranslation','globaladmin'));


/*
 * Actions
 */

if (GETPOST('cancel')) { $action='list'; $massaction=''; }
if (! GETPOST('confirmmassaction') && $massaction != 'presend' && $massaction != 'confirm_presend') { $massaction=''; }

$parameters=array('socid'=>$socid);
$reshook=$hookmanager->executeHooks('doActions',$parameters,$object,$action);    // Note that $action and $object may have been modified by some hooks
if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

include DOL_DOCUMENT_ROOT.'/core/actions_changeselectedfields.inc.php';

// Purge search criteria
if (GETPOST('button_removefilter_x','alpha') || GETPOST('button_removefilter.x','alpha') || GETPOST('button_removefilter','alpha')) // All tests are required to be compatible with all browsers
{
    $transkey='';
    $transvalue='';
    $toselect='';
    $search_array_options=array();
}

if ($action == 'setMAIN_ENABLE_OVERWRITE_TRANSLATION')
{
    if (GETPOST('value')) dolibarr_set_const($db, 'MAIN_ENABLE_OVERWRITE_TRANSLATION', 1, 'chaine', 0, '', $conf->entity);
    else dolibarr_set_const($db, 'MAIN_ENABLE_OVERWRITE_TRANSLATION', 0, 'chaine', 0, '', $conf->entity);
}

if ($action == 'add' || (GETPOST('add') && $action != 'update'))
{
	$error=0;

	if (empty($langcode))
	{
		setEventMessages($langs->trans("ErrorFieldRequired", $langs->transnoentitiesnoconv("Language")), null, 'errors');
		$error++;
	}
	if ($transkey == '')
	{
		setEventMessages($langs->trans("ErrorFieldRequired", $langs->transnoentitiesnoconv("Key")), null, 'errors');
		$error++;
	}
	if ($transvalue == '')
	{
		setEventMessages($langs->trans("ErrorFieldRequired", $langs->transnoentitiesnoconv("NewTranslationStringToShow")), null, 'errors');
		$error++;
	}
	if (! $error)
	{
	    $db->begin();

	    $sql = "INSERT INTO ".MAIN_DB_PREFIX."overwrite_trans(lang, transkey, transvalue, entity) VALUES ('".$db->escape($langcode)."','".$db->escape($transkey)."','".$db->escape($transvalue)."', ".$db->escape($conf->entity).")";
		$result = $db->query($sql);
		if ($result > 0)
		{
		    $db->commit();
		    setEventMessages($langs->trans("RecordSaved"), null, 'mesgs');
			$action="";
			$transkey="";
			$transvalue="";
		}
		else
		{

		    $db->rollback();
		    if ($db->lasterrno() == 'DB_ERROR_RECORD_ALREADY_EXISTS')
		    {
		        setEventMessages($langs->trans("WarningAnEntryAlreadyExistForTransKey"), null, 'warnings');
		    }
		    else
		    {
		        setEventMessages($db->lasterror(), null, 'errors');
		    }
			$action='';
		}
	}
}

// Delete line from delete picto
if ($action == 'delete')
{
	$sql = "DELETE FROM ".MAIN_DB_PREFIX."overwrite_trans WHERE rowid = ".$db->escape($id);
	$result = $db->query($sql);
	if ($result >= 0)
	{
		setEventMessages($langs->trans("RecordDeleted"), null, 'mesgs');
	}
	else
	{
		dol_print_error($db);
	}
}






/*
 * View
 */

$form = new Form($db);
$formadmin = new FormAdmin($db);

$wikihelp='EN:Setup|FR:Paramétrage|ES:Configuración';
llxHeader('',$langs->trans("Setup"),$wikihelp);

$param='&mode='.$mode;

$enabledisablehtml = $langs->trans("EnableOverwriteTranslation").' ';
if (empty($conf->global->MAIN_ENABLE_OVERWRITE_TRANSLATION))
{
    // Button off, click to enable
    $enabledisablehtml.='<a class="reposition" href="'.$_SERVER["PHP_SELF"].'?action=setMAIN_ENABLE_OVERWRITE_TRANSLATION&value=1'.$param.'">';
    $enabledisablehtml.=img_picto($langs->trans("Disabled"),'switch_off');
    $enabledisablehtml.='</a>';
}
else
{
    // Button on, click to disable
    $enabledisablehtml.='<a class="reposition" href="'.$_SERVER["PHP_SELF"].'?action=setMAIN_ENABLE_OVERWRITE_TRANSLATION&value=0'.$param.'">';
    $enabledisablehtml.=img_picto($langs->trans("Activated"),'switch_on');
    $enabledisablehtml.='</a>';
}

print load_fiche_titre($langs->trans("Translation"), $enabledisablehtml, 'title_setup');

print $langs->trans("TranslationDesc")."<br>\n";
print "<br>\n";

$current_language_code=$langs->defaultlang;
$s=picto_from_langcode($current_language_code);
print $langs->trans("CurrentUserLanguage").': <strong>'.$s.' '.$current_language_code.'</strong><br>';

print '<br>';

if (! empty($contextpage) && $contextpage != $_SERVER["PHP_SELF"]) $param.='&contextpage='.$contextpage;
if ($limit > 0 && $limit != $conf->liste_limit) $param.='&limit='.$limit;
if ($optioncss != '') $param.='&optioncss='.$optioncss;
if ($langcode)        $param.='&langcode='.urlencode($langcode);
if ($transkey)        $param.='&transkey='.urlencode($transkey);
if ($transvalue)      $param.='&transvalue='.urlencode($transvalue);


print '<form action="'.$_SERVER["PHP_SELF"].((empty($user->entity) && $debug)?'?debug=1':'').'" method="POST">';
if ($optioncss != '') print '<input type="hidden" name="optioncss" value="'.$optioncss.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="formfilteraction" id="formfilteraction" value="list">';
print '<input type="hidden" name="action" value="list">';
print '<input type="hidden" name="sortfield" value="'.$sortfield.'">';
print '<input type="hidden" name="sortorder" value="'.$sortorder.'">';
print '<input type="hidden" name="page" value="'.$page.'">';

$head=translation_prepare_head();

dol_fiche_head($head, $mode, '', -1, '');

if ($mode == 'overwrite')
{
    //print load_fiche_titre($langs->trans("TranslationOverwriteKey"), '', '')."\n";

    print img_info().' '.$langs->trans("SomeTranslationAreUncomplete");
    $urlwikitranslatordoc='https://wiki.dolibarr.org/index.php/Translator_documentation';
    print ' ('.$langs->trans("SeeAlso").': <a href="'.$urlwikitranslatordoc.'" target="_blank">'.$urlwikitranslatordoc.'</a>)<br>';
    print $langs->trans("TranslationOverwriteDesc",$langs->transnoentitiesnoconv("Language"),$langs->transnoentitiesnoconv("Key"),$langs->transnoentitiesnoconv("NewTranslationStringToShow"))."\n";
    print ' ('.$langs->trans("TranslationOverwriteDesc2").').'."<br>\n";
    print '<br>';


    print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
    print '<input type="hidden" id="action" name="action" value="">';
    print '<input type="hidden" id="mode" name="mode" value="'.$mode.'">';

	print '<div class="div-table-responsive-no-min">';
    print '<table class="noborder" width="100%">';
    print '<tr class="liste_titre">';
    print_liste_field_titre( $langs->trans("Language").' (en_US, es_MX, ...)',$_SERVER["PHP_SELF"],'lang,transkey','',$param,'',$sortfield,$sortorder);
    print_liste_field_titre("Key",$_SERVER["PHP_SELF"],'transkey','',$param,'',$sortfield,$sortorder);
    print_liste_field_titre("NewTranslationStringToShow",$_SERVER["PHP_SELF"],'transvalue','',$param,'',$sortfield,$sortorder);
    //if (! empty($conf->multicompany->enabled) && !$user->entity) print_liste_field_titre("Entity"),$_SERVER["PHP_SELF"],'entity,transkey','',$param,'',$sortfield,$sortorder);
    print '<td align="center"></td>';
    print "</tr>\n";


    // Line to add new record
    print "\n";

    print '<tr class="oddeven"><td>';
    print $formadmin->select_language(GETPOST('langcode'), 'langcode', 0, null, 1, 0, 0, 'maxwidthonsmartphone', 1);
    print '</td>'."\n";
    print '<td>';
    print '<input type="text" class="flat maxwidthonsmartphone" name="transkey" value="">';
    print '</td><td>';
    print '<input type="text" class="quatrevingtpercent" name="transvalue" value="">';
    print '</td>';
    // Limit to superadmin
    /*if (! empty($conf->multicompany->enabled) && !$user->entity)
    {
    	print '<td>';
    	print '<input type="text" class="flat" size="1" name="entity" value="'.$conf->entity.'">';
    	print '</td>';
    	print '<td align="center">';
    }
    else
    {*/
    	print '<td align="center">';
    	print '<input type="hidden" name="entity" value="'.$conf->entity.'">';
    //}
    $disabled='';
    if (empty($conf->global->MAIN_ENABLE_OVERWRITE_TRANSLATION)) $disabled=' disabled="disabled"';
    print '<input type="submit" class="button"'.$disabled.' value="'.$langs->trans("Add").'" name="add">';
    print "</td>\n";
    print '</tr>';


    // Show constants
    $sql = "SELECT rowid, entity, lang, transkey, transvalue";
    $sql.= " FROM ".MAIN_DB_PREFIX."overwrite_trans";
    $sql.= " WHERE 1 = 1";
    //$sql.= " AND entity IN (".$user->entity.",".$conf->entity.")";
    $sql.= $db->order($sortfield, $sortorder);

    dol_syslog("translation::select from table", LOG_DEBUG);
    $result = $db->query($sql);
    if ($result)
    {
    	$num = $db->num_rows($result);
    	$i = 0;

    	while ($i < $num)
    	{
    		$obj = $db->fetch_object($result);

    		print "\n";

    		print '<tr class="oddeven">';

    		print '<td>'.$obj->lang.'</td>'."\n";
    		print '<td>'.$obj->transkey.'</td>'."\n";

    		// Value
    		print '<td>';
    		/*print '<input type="hidden" name="const['.$i.'][rowid]" value="'.$obj->rowid.'">';
    		print '<input type="hidden" name="const['.$i.'][lang]" value="'.$obj->lang.'">';
    		print '<input type="hidden" name="const['.$i.'][name]" value="'.$obj->transkey.'">';
    		print '<input type="text" id="value_'.$i.'" class="flat inputforupdate" size="30" name="const['.$i.'][value]" value="'.dol_escape_htmltag($obj->transvalue).'">';
    		*/
    		print $obj->transvalue;
    		print '</td>';

    		print '<td align="center">';
    		print '<a href="'.$_SERVER['PHP_SELF'].'?rowid='.$obj->rowid.'&entity='.$obj->entity.'&action=delete'.((empty($user->entity) && $debug)?'&debug=1':'').'">'.img_delete().'</a>';
    		print '</td>';

    		print "</tr>\n";
    		print "\n";
    		$i++;
    	}
    }

    print '</table>';
    print '</div>';

}

if ($mode == 'searchkey')
{
    $langcode=GETPOST('langcode')?GETPOST('langcode'):$langs->defaultlang;

    $newlang=new Translate('',$conf);
    $newlang->setDefaultLang($langcode);

    $newlangfileonly=new Translate('',$conf);
    $newlangfileonly->setDefaultLang($langcode);

    $recordtoshow=array();

    // Search modules dirs
    $modulesdir = dolGetModulesDirs();

    $nbempty=0;
    /*var_dump($langcode);
     var_dump($transkey);
     var_dump($transvalue);*/
    if (empty($langcode) || $langcode == '-1') $nbempty++;
    if (empty($transkey)) $nbempty++;
    if (empty($transvalue)) $nbempty++;
    if ($action == 'search' && ($nbempty > 999))    // 999 to disable this
    {
        setEventMessages($langs->trans("WarningAtLeastKeyOrTranslationRequired"), null, 'warnings');
    }
    else
    {
        // Search into dir of modules (the $modulesdir is already a list that loop on $conf->file->dol_document_root)
        foreach($modulesdir as $keydir => $tmpsearchdir)
        {
        	$searchdir = $tmpsearchdir;		// $searchdir can be '.../htdocs/core/modules/' or '.../htdocs/custom/mymodule/core/modules/'

        	// Directory of translation files
        	$dir_lang = dirname(dirname($searchdir))."/langs/".$langcode;	// The 2 dirname is to go up in dir for 2 levels
        	$dir_lang_osencoded=dol_osencode($dir_lang);

        	$filearray=dol_dir_list($dir_lang_osencoded,'files',0,'','',$sortfield,(strtolower($sortorder)=='asc'?SORT_ASC:SORT_DESC),1);
        	foreach($filearray as $file)
        	{
        		$tmpfile=preg_replace('/.lang/i', '', basename($file['name']));
        		//Detect if trans coming from extranl module
        		foreach ($conf->file->dol_document_root as $keyconf=>$dirconfalt) {
        			if (($keyconf!='main') && (preg_match('$'.preg_quote($dirconfalt).'$i', $file['fullname']))) {
        				//In this case load modulename@nmodulename
        				$tmpfile=$tmpfile.'@'.$tmpfile;
        				break;
        			}
        		}
        		$newlang->load($tmpfile, 0, 0, '', 0);                              // Load translation files + database overwrite
        		$newlangfileonly->load($tmpfile, 0, 0, '', 1);                      // Load translation files only
        		//print 'After loading lang '.$tmpfile.', newlang has '.count($newlang->tab_translate).' records<br>'."\n";
        	}
        }

        // Now search into translation array
        foreach($newlang->tab_translate as $key => $val)
        {
            if ($transkey && ! preg_match('/'.preg_quote($transkey).'/i', $key)) continue;
            if ($transvalue && ! preg_match('/'.preg_quote($transvalue).'/i', $val)) continue;
            $recordtoshow[$key]=$val;
        }
    }

    //print '<br>';
    $nbtotalofrecordswithoutfilters = count($newlang->tab_translate);
    $nbtotalofrecords = count($recordtoshow);
    $num = $limit + 1;
    if (($offset + $num) > $nbtotalofrecords) $num = $limit;

    //print 'param='.$param.' $_SERVER["PHP_SELF"]='.$_SERVER["PHP_SELF"].' num='.$num.' page='.$page.' nbtotalofrecords='.$nbtotalofrecords." sortfield=".$sortfield." sortorder=".$sortorder;
    $title = $langs->trans("TranslationKeySearch");
    if ($nbtotalofrecords > 0) $title.=' ('.$nbtotalofrecords.' / '.$nbtotalofrecordswithoutfilters.')';
    print print_barre_liste($title, $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, -1 * $nbtotalofrecords, '', 0, '', '', $limit)."\n";

    print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
    print '<input type="hidden" id="action" name="action" value="search">';
    print '<input type="hidden" id="mode" name="mode" value="'.$mode.'">';

	print '<div class="div-table-responsive-no-min">';
    print '<table class="noborder" width="100%">';
    print '<tr class="liste_titre">';
    print_liste_field_titre( $langs->trans("Language").' (en_US, es_MX, ...)',$_SERVER["PHP_SELF"],'lang,transkey','',$param,'',$sortfield,$sortorder).'</td>';
    print_liste_field_titre("Key",$_SERVER["PHP_SELF"],'transkey','',$param,'',$sortfield,$sortorder);
    print_liste_field_titre("CurrentTranslationString",$_SERVER["PHP_SELF"],'transvalue','',$param,'',$sortfield,$sortorder);
    //if (! empty($conf->multicompany->enabled) && !$user->entity) print_liste_field_titre("Entity",$_SERVER["PHP_SELF"],'entity,transkey','',$param,'',$sortfield,$sortorder);
    print '<td align="center"></td>';
    print "</tr>\n";

    // Line to search new record
    print "\n";

    print '<tr class="oddeven"><td>';
    //print $formadmin->select_language($langcode,'langcode',0,null,$langs->trans("All"),0,0,'',1);
    print $formadmin->select_language($langcode,'langcode', 0, null, 0, 0, 0, 'maxwidthonsmartphone', 1);
    print '</td>'."\n";
    print '<td>';
    print '<input type="text" class="flat maxwidthonsmartphone" name="transkey" value="'.$transkey.'">';
    print '</td><td>';
    print '<input type="text" class="quatrevingtpercent" name="transvalue" value="'.$transvalue.'">';
    // Limit to superadmin
    /*if (! empty($conf->multicompany->enabled) && !$user->entity)
    {
        print '</td><td>';
        print '<input type="text" class="flat" size="1" name="entitysearch" value="'.$conf->entity.'">';
    }
    else
    {*/
        print '<input type="hidden" name="entitysearch" value="'.$conf->entity.'">';
    //}
    print '</td>';
    // Action column
    print '<td class="liste_titre nowrap" align="right">';
    $searchpicto=$form->showFilterAndCheckAddButtons($massactionbutton?1:0, 'checkforselect', 1);
    print $searchpicto;
    print '</td>';
    print '</tr>';

    if ($sortfield == 'transkey' && strtolower($sortorder) == 'asc') ksort($recordtoshow);
    if ($sortfield == 'transkey' && strtolower($sortorder) == 'desc') krsort($recordtoshow);
    if ($sortfield == 'transvalue' && strtolower($sortorder) == 'asc') asort($recordtoshow);
    if ($sortfield == 'transvalue' && strtolower($sortorder) == 'desc') arsort($recordtoshow);

    // Show result
    $i=0;
    foreach($recordtoshow as $key => $val)
    {
        $i++;
        if ($i <= $offset) continue;
        if ($i > ($offset + $limit)) break;
        print '<tr class="oddeven"><td>'.$langcode.'</td><td>'.$key.'</td><td>';
        print dol_escape_htmltag($val);
        print '</td><td align="right">';
        if (! empty($newlangfileonly->tab_translate[$key]))
        {
            if ($val != $newlangfileonly->tab_translate[$key])
            {
                $htmltext = $langs->trans("OriginalValueWas", $newlangfileonly->tab_translate[$key]);
                print $form->textwithpicto('', $htmltext, 1, 'info');
            }
        }
        else
        {
            $htmltext = $langs->trans("TransKeyWithoutOriginalValue", $key);
            print $form->textwithpicto('', $htmltext, 1, 'warning');
        }
        /*if (! empty($conf->multicompany->enabled) && !$user->entity)
        {
            print '<td>'.$val.'</td>';
        }*/
        print '</td></tr>'."\n";
    }

    print '</table>';
    print '</div>';
}

dol_fiche_end();

print "</form>\n";


llxFooter();

$db->close();
